/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPInteger
extends REXPVector {
    protected int[] payload;
    public static final int NA = Integer.MIN_VALUE;

    public static boolean isNA(int n) {
        return n == Integer.MIN_VALUE;
    }

    public REXPInteger(int n) {
        this.payload = new int[]{n};
    }

    public REXPInteger(int[] nArray) {
        this.payload = nArray == null ? new int[]{} : nArray;
    }

    public REXPInteger(int[] nArray, REXPList rEXPList) {
        super(rEXPList);
        this.payload = nArray == null ? new int[]{} : nArray;
    }

    @Override
    public Object asNativeJavaObject() {
        return this.payload;
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public int[] asIntegers() {
        return this.payload;
    }

    @Override
    public double[] asDoubles() {
        double[] dArray = new double[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            dArray[i] = this.payload[i];
        }
        return dArray;
    }

    @Override
    public String[] asStrings() {
        String[] stringArray = new String[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            stringArray[i] = "" + this.payload[i];
        }
        return stringArray;
    }

    @Override
    public boolean[] isNA() {
        boolean[] blArray = new boolean[this.payload.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.payload[i] == Integer.MIN_VALUE;
        }
        return blArray;
    }

    @Override
    public String toDebugString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toDebugString() + "{");
        for (n = 0; n < this.payload.length && n < maxDebugItems; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.payload[n]);
        }
        if (n < this.payload.length) {
            stringBuffer.append(",..");
        }
        return stringBuffer.toString() + "}";
    }
}

