* created 15.11.2019 (CET) by wrightp *.
* source system: secuTrial 5.5.1.10 *.
* project 'secuTrialR example CDMA' *.
* centre 'Charité Berlin (RPACK)' *.
* centre 'Inselspital Bern (RPACK)' *.
* centre 'Universitätsspital Basel (RPACK)' *.
* NOTE: It is recommended to replace the relative paths to the            *.
*       data files in "dat" with the absolute paths before execution.     *.


GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/vp.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnpvisid F10.0
 visitnumber F4.0
 visittype F2.0
 previsid F10.0
 visitday F10.0
 minusoffset F10.0
 plusoffset F10.0
 visitarm A100
 hidden F2.0
 mnpvislabel A50
 mnpvsno F10.0
 mnpvslbl A30
 .
VARIABLE LABELS
 mnpvisid 'Visit-ID'
 visitnumber 'Visit sequence'
 visittype 'Type of visit'
 previsid 'Preceding visit-ID'
 visitday 'Time lag to preceding visit (days)'
 minusoffset 'Possible negative time frame (days)'
 plusoffset 'Possible positive time frame (days)'
 visitarm 'Treatment arm'
 hidden 'hidden in DataCapture'
 mnpvislabel 'Visit label'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 .
VALUE LABELS visittype
 0 'fixed'
 1 'flexible'
 2 'unscheduled'
 3 'free'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME vp
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/vp.sav'
 .
DATASET CLOSE vp
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/vpfs.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnpvisid F10.0
 formid F10.0
 .
VARIABLE LABELS
 mnpvisid 'Visit-ID'
 formid 'Form-ID'
 .
CACHE.
EXECUTE.
DATASET NAME vpfs
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/vpfs.sav'
 .
DATASET CLOSE vpfs
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/fs.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 formid F10.0
 formtablename A24
 hidden F2.0
 formname A200
 formfamily A100
 sequence F10.0
 mnpvsno F10.0
 mnpvslbl A30
 .
VARIABLE LABELS
 formid 'Form-ID'
 formtablename 'DB table name'
 hidden 'hidden in DataCapture'
 formname 'Form name (as in matrix)'
 formfamily 'Form family name'
 sequence 'Form sequence in form family'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME fs
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/fs.sav'
 .
DATASET CLOSE fs
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/qs.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 fgid F10.0
 formid F10.0
 formtablename A24
 formname A200
 sequence F10.0
 hidden F2.0
 fglabel A200
 subformtablename A24
 .
VARIABLE LABELS
 fgid 'Question-ID'
 formid 'Form-ID'
 formtablename 'DB table name'
 formname 'Form name (as in matrix)'
 sequence 'Question sequence in form'
 hidden 'hidden in DataCapture'
 fglabel 'Question label (or unique label for search)'
 subformtablename 'Sub-form DB table name'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME qs
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/qs.sav'
 .
DATASET CLOSE qs
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/is.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 ffid F10.0
 fgid F10.0
 sequence F10.0
 ffcolname A32
 itemtype A200
 hidden F2.0
 fflabel A2500
 unit A200
 lookuptable A30
 .
VARIABLE LABELS
 ffid 'Item-ID'
 fgid 'Question-ID'
 sequence 'Item sequence in question'
 ffcolname 'DB column name'
 itemtype 'Item component type'
 hidden 'hidden in DataCapture'
 fflabel 'Item label (or question label or unique label for search)'
 unit 'Unit / additional text'
 lookuptable 'Name of lookup table'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME is
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/is.sav'
 .
DATASET CLOSE is
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/ctr.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnpctrid F10.0
 mnpctrname A100
 mnpcname A200
 .
VARIABLE LABELS
 mnpctrid 'Centre-ID'
 mnpctrname 'Centre name'
 mnpcname 'Country name'
 .
CACHE.
EXECUTE.
DATASET NAME ctr
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/ctr.sav'
 .
DATASET CLOSE ctr
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/cn.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpaid A20
 mnp_rando_treatment_gr A100
 mnpcnptnid F10.0
 mnpctrid F10.0
 mnpcs0 F2.0
 mnpcs1 F2.0
 mnpcs2 F2.0
 mnpcs3 F2.0
 mnpcs4 F2.0
 mnpcs5 F2.0
 mnpcs6 F2.0
 mnpcs7 F2.0
 mnpvisstartdate DATE11
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpaid 'Patient identifier'
 mnp_rando_treatment_gr 'Randomization (group)'
 mnpcnptnid 'Participant-ID'
 mnpctrid 'Centre-ID'
 mnpcs0 'Case status 0'
 mnpcs1 'Case status 1'
 mnpcs2 'Case status 2'
 mnpcs3 'Case status 3'
 mnpcs4 'Case status 4'
 mnpcs5 'Case status 5'
 mnpcs6 'Case status 6'
 mnpcs7 'Case status 7'
 mnpvisstartdate 'Entry date'
 .
VALUE LABELS mnpcnptnid
 381 'Patrick Wright'
 .
VALUE LABELS mnpcs0
 0 ''
 1 'not shown'
 .
VALUE LABELS mnpcs1
 0 ''
 1 'to be anonymized / anonymized'
 .
VALUE LABELS mnpcs2
 0 ''
 1 'frozen'
 .
VALUE LABELS mnpcs3
 0 ''
 1 'frozen'
 .
VALUE LABELS mnpcs4
 0 ''
 1 'deceased'
 .
VALUE LABELS mnpcs5
 0 ''
 1 'Project: frozen'
 .
VALUE LABELS mnpcs6
 0 ''
 1 'Project: to be deleted'
 .
VALUE LABELS mnpcs7
 0 ''
 1 'Project: visit plan closed'
 .
CACHE.
EXECUTE.
DATASET NAME cn
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/cn.sav'
 .
DATASET CLOSE cn
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atcn.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 oldvisitstartdate DATE11
 newvisitstartdate DATE11
 mnpptnid F10.0
 changedate DATETIME23.2
 changereason A200
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 oldvisitstartdate 'Old entry date'
 newvisitstartdate 'New entry date'
 mnpptnid 'Participant-ID'
 changedate 'Date of change'
 changereason 'Reason for change'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
CACHE.
EXECUTE.
DATASET NAME atcn
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atcn.sav'
 .
DATASET CLOSE atcn
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atcvp.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpcvpid F10.0
 oldmnpvispdt DATE11
 newmnpvispdt DATE11
 oldmnpvisid F10.0
 newmnpvisid F10.0
 oldmnpvisno F10.0
 newmnpvisno F10.0
 oldhidden F2.0
 newhidden F2.0
 mnpptnid F10.0
 changedate DATETIME23.2
 changereason A200
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpcvpid 'Patient visit-ID'
 oldmnpvispdt 'Old planned date of visit'
 newmnpvispdt 'New planned date of visit'
 oldmnpvisid 'Old visit-ID'
 newmnpvisid 'New visit-ID'
 oldmnpvisno 'Old patient-visit number'
 newmnpvisno 'New patient-visit number'
 oldhidden 'Old hidden flag'
 newhidden 'New hidden flag'
 mnpptnid 'Participant-ID'
 changedate 'Date of change'
 changereason 'Reason for change'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS oldhidden
 0 'no'
 1 'yes'
 .
VALUE LABELS newhidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atcvp
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atcvp.sav'
 .
DATASET CLOSE atcvp
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atae1.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpaeid F10.0
 mnpaefuid F10.0
 olddate DATETIME23.2
 newdate DATETIME23.2
 oldmnpaeno F10.0
 newmnpaeno F10.0
 oldhidden F2.0
 newhidden F2.0
 mnpptnid F10.0
 changedate DATETIME23.2
 changereason A200
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpaeid 'Adverse Event-ID'
 mnpaefuid 'Adverse Event Follow-up-ID'
 olddate 'Old date'
 newdate 'New date'
 oldmnpaeno 'Old patient adverse event number'
 newmnpaeno 'New patient adverse event number'
 oldhidden 'Old hidden flag'
 newhidden 'New hidden flag'
 mnpptnid 'Participant-ID'
 changedate 'Date of change'
 changereason 'Reason for change'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS oldhidden
 0 'no'
 1 'yes'
 .
VALUE LABELS newhidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atae1
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atae1.sav'
 .
DATASET CLOSE atae1
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/qac.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 ffid F10.0
 ffcolname A32
 hidden F2.0
 qacdate DATETIME23.2
 mnpqueryid F10.0
 querystatus F2.0
 qacstatus F2.0
 mnpptnid F10.0
 qaccontent A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 ffid 'Item-ID'
 ffcolname 'DB column name'
 hidden 'hidden in DataCapture'
 qacdate 'Date of entry'
 mnpqueryid 'Query-ID'
 querystatus 'Query status (calculated status)'
 qacstatus 'QAC status (type of query-entry)'
 mnpptnid 'Participant-ID'
 qaccontent 'Content'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS querystatus
 0 'withdrawn'
 1 'open'
 2 'answered'
 4 'resolved'
 .
VALUE LABELS qacstatus
 0 'withdrawn'
 1 'open'
 2 'answered'
 4 'resolved'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME qac
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/qac.sav'
 .
DATASET CLOSE qac
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/cts.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 ffid F10.0
 ffcolname A32
 hidden F2.0
 qacdate DATETIME23.2
 mnpcommentid F10.0
 mnpptnid F10.0
 qaccontent A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 ffid 'Item-ID'
 ffcolname 'DB column name'
 hidden 'hidden in DataCapture'
 qacdate 'Date of entry'
 mnpcommentid 'Comment-ID'
 mnpptnid 'Participant-ID'
 qaccontent 'Content'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME cts
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/cts.sav'
 .
DATASET CLOSE cts
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/miv.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 ffid F10.0
 ffcolname A32
 hidden F2.0
 editdate DATETIME23.2
 mivstatus F2.0
 mivstatustext A250
 mnpptnid F10.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 ffid 'Item-ID'
 ffcolname 'DB column name'
 hidden 'hidden in DataCapture'
 editdate 'Date of entry'
 mivstatus 'Status MV'
 mivstatustext 'Other reason for MV'
 mnpptnid 'Participant-ID'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS mivstatus
 2 'Value not collected'
 3 'Other reason for missing value'
 4 'Value not collected due to rule'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME miv
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/miv.sav'
 .
DATASET CLOSE miv
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atmiv.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpatdocid F10.0
 ffid F10.0
 ffcolname A32
 hidden F2.0
 editdate DATETIME23.2
 mivstatus F2.0
 mivstatustext A250
 mnpptnid F10.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpatdocid 'ATDocument-ID'
 ffid 'Item-ID'
 ffcolname 'DB column name'
 hidden 'hidden in DataCapture'
 editdate 'Date of entry'
 mivstatus 'Status MV'
 mivstatustext 'Other reason for MV'
 mnpptnid 'Participant-ID'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS mivstatus
 2 'Value not collected'
 3 'Other reason for missing value'
 4 'Value not collected due to rule'
 .
VALUE LABELS hidden
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atmiv
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atmiv.sav'
 .
DATASET CLOSE atmiv
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/baseline.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 visit_date A8
 birth_year A4
 age F22.0
 gender F10.0
 height F7.1
 weight F8.2
 no_clinical_data F2.0
 hospitalisation F10.0
 icu F10.0
 surgery F10.0
 immunodeficiency F10.0
 hiv F10.0
 hiv_date_uknwn F2.0
 hiv_date A12
 liver_cirrh F10.0
 liver_cirrh_type F10.0
 other_comorb F10.0
 other_comorb_type A40
 painkiller F10.0
 paracetamol F2.0
 treat_type_paracet F10.0
 paracetamol_unknown F2.0
 paracetamol_start A8
 paracetamol_stop A8
 ibuprofen F2.0
 treat_type_ibuprofen F10.0
 ibuprofen_unknown F2.0
 ibuprofen_start A8
 ibuprofen_stop A8
 aspirin F2.0
 treat_type_aspirin F10.0
 aspirin_unknown F2.0
 aspirin_start A8
 aspirin_stop A8
 baseline_comments A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 visit_date 'Date of visit'
 birth_year 'Birth year'
 age 'Age'
 gender 'Gender'
 height 'Height'
 weight 'Weight'
 no_clinical_data 'No clinical data'
 hospitalisation 'Hospitalisation'
 icu 'ICU => ICU'
 surgery 'Surgery since last screen?'
 immunodeficiency 'Immunodeficiency'
 hiv 'HIV => HIV'
 hiv_date_uknwn 'HIV date unknown'
 hiv_date 'HIV HIV diagnosis date'
 liver_cirrh 'Liver cirrhosis Liver cirrhosis'
 liver_cirrh_type 'Liver cirrhosis type => type'
 other_comorb 'Other comorbidity Other comorbidity'
 other_comorb_type 'Other comorbidity type => type'
 painkiller 'Treatment with painkillers?'
 paracetamol 'Paracetamol'
 treat_type_paracet 'prior treatment type Paracetamol Treatment Type'
 paracetamol_unknown 'prior Paracetamol unknown Treatment interval unknown'
 paracetamol_start 'prior Paracetamol start Treatment start'
 paracetamol_stop 'prior Paracetamol stop Treatment stop'
 ibuprofen 'Ibuprofen'
 treat_type_ibuprofen 'prior treatment type Ibuprofen Treatment Type'
 ibuprofen_unknown 'prior Ibuprofen unknown Treatment interval unknown'
 ibuprofen_start 'prior Ibuprofen start Treatment start'
 ibuprofen_stop 'prior Ibuprofen stop Treatment stop'
 aspirin 'Aspirin'
 treat_type_aspirin 'prior treatment type Aspirin Treatment Type'
 aspirin_unknown 'prior Aspirin unknown Treatment interval unknown'
 aspirin_start 'prior Aspirin start Treatment start'
 aspirin_stop 'prior Aspirin stop Treatment stop'
 baseline_comments 'Comments'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS gender
 1 'male'
 2 'female'
 .
VALUE LABELS no_clinical_data
 0 'no'
 1 'yes'
 .
VALUE LABELS hospitalisation
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS icu
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS surgery
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS immunodeficiency
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS hiv
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS hiv_date_uknwn
 0 'no'
 1 'yes'
 .
VALUE LABELS liver_cirrh
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS liver_cirrh_type
 1 'A'
 2 'B'
 3 'C'
 .
VALUE LABELS other_comorb
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS painkiller
 1 'yes'
 0 'no'
 4 'unknown'
 .
VALUE LABELS paracetamol
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_paracet
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS paracetamol_unknown
 0 'no'
 1 'yes'
 .
VALUE LABELS ibuprofen
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_ibuprofen
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS ibuprofen_unknown
 0 'no'
 1 'yes'
 .
VALUE LABELS aspirin
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_aspirin
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS aspirin_unknown
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME baseline
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/baseline.sav'
 .
DATASET CLOSE baseline
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atbaseline.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 visit_date A8
 birth_year A4
 age F22.0
 gender F10.0
 height F7.1
 weight F8.2
 no_clinical_data F2.0
 hospitalisation F10.0
 icu F10.0
 surgery F10.0
 immunodeficiency F10.0
 hiv F10.0
 hiv_date_uknwn F2.0
 hiv_date A12
 liver_cirrh F10.0
 liver_cirrh_type F10.0
 other_comorb F10.0
 other_comorb_type A40
 painkiller F10.0
 paracetamol F2.0
 treat_type_paracet F10.0
 paracetamol_unknown F2.0
 paracetamol_start A8
 paracetamol_stop A8
 ibuprofen F2.0
 treat_type_ibuprofen F10.0
 ibuprofen_unknown F2.0
 ibuprofen_start A8
 ibuprofen_stop A8
 aspirin F2.0
 treat_type_aspirin F10.0
 aspirin_unknown F2.0
 aspirin_start A8
 aspirin_stop A8
 baseline_comments A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 visit_date 'Date of visit'
 birth_year 'Birth year'
 age 'Age'
 gender 'Gender'
 height 'Height'
 weight 'Weight'
 no_clinical_data 'No clinical data'
 hospitalisation 'Hospitalisation'
 icu 'ICU => ICU'
 surgery 'Surgery since last screen?'
 immunodeficiency 'Immunodeficiency'
 hiv 'HIV => HIV'
 hiv_date_uknwn 'HIV date unknown'
 hiv_date 'HIV HIV diagnosis date'
 liver_cirrh 'Liver cirrhosis Liver cirrhosis'
 liver_cirrh_type 'Liver cirrhosis type => type'
 other_comorb 'Other comorbidity Other comorbidity'
 other_comorb_type 'Other comorbidity type => type'
 painkiller 'Treatment with painkillers?'
 paracetamol 'Paracetamol'
 treat_type_paracet 'prior treatment type Paracetamol Treatment Type'
 paracetamol_unknown 'prior Paracetamol unknown Treatment interval unknown'
 paracetamol_start 'prior Paracetamol start Treatment start'
 paracetamol_stop 'prior Paracetamol stop Treatment stop'
 ibuprofen 'Ibuprofen'
 treat_type_ibuprofen 'prior treatment type Ibuprofen Treatment Type'
 ibuprofen_unknown 'prior Ibuprofen unknown Treatment interval unknown'
 ibuprofen_start 'prior Ibuprofen start Treatment start'
 ibuprofen_stop 'prior Ibuprofen stop Treatment stop'
 aspirin 'Aspirin'
 treat_type_aspirin 'prior treatment type Aspirin Treatment Type'
 aspirin_unknown 'prior Aspirin unknown Treatment interval unknown'
 aspirin_start 'prior Aspirin start Treatment start'
 aspirin_stop 'prior Aspirin stop Treatment stop'
 baseline_comments 'Comments'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS gender
 1 'male'
 2 'female'
 .
VALUE LABELS no_clinical_data
 0 'no'
 1 'yes'
 .
VALUE LABELS hospitalisation
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS icu
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS surgery
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS immunodeficiency
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS hiv
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS hiv_date_uknwn
 0 'no'
 1 'yes'
 .
VALUE LABELS liver_cirrh
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS liver_cirrh_type
 1 'A'
 2 'B'
 3 'C'
 .
VALUE LABELS other_comorb
 1 'yes'
 0 'no'
 98 'unknown'
 .
VALUE LABELS painkiller
 1 'yes'
 0 'no'
 4 'unknown'
 .
VALUE LABELS paracetamol
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_paracet
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS paracetamol_unknown
 0 'no'
 1 'yes'
 .
VALUE LABELS ibuprofen
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_ibuprofen
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS ibuprofen_unknown
 0 'no'
 1 'yes'
 .
VALUE LABELS aspirin
 0 'no'
 1 'yes'
 .
VALUE LABELS treat_type_aspirin
 1 'prophylaxis'
 2 'treatment'
 98 'unknown'
 .
VALUE LABELS aspirin_unknown
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atbaseline
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atbaseline.sav'
 .
DATASET CLOSE atbaseline
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/outcome.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 follow_up F10.0
 death_date A8
 outcome_description A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 follow_up 'Follow-up'
 death_date 'Exact date of death'
 outcome_description 'Optional description of outcome'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS follow_up
 1 'death'
 3 'ongoing consultation'
 98 'unknown'
 .
CACHE.
EXECUTE.
DATASET NAME outcome
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/outcome.sav'
 .
DATASET CLOSE outcome
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atoutcome.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 follow_up F10.0
 death_date A8
 outcome_description A1000
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 follow_up 'Follow-up'
 death_date 'Exact date of death'
 outcome_description 'Optional description of outcome'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS follow_up
 1 'death'
 3 'ongoing consultation'
 98 'unknown'
 .
CACHE.
EXECUTE.
DATASET NAME atoutcome
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atoutcome.sav'
 .
DATASET CLOSE atoutcome
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/treatment.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 rando_treatment A100
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 rando_treatment 'Randomization'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME treatment
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/treatment.sav'
 .
DATASET CLOSE treatment
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/attreatment.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 rando_treatment A100
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 rando_treatment 'Randomization'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME attreatment
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/attreatment.sav'
 .
DATASET CLOSE attreatment
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/allmedi.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 no_more_meds F2.0
 med_family A15
 med_product A16
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 no_more_meds 'No further medication'
 med_family 'Family'
 med_product 'Product'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS no_more_meds
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME allmedi
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/allmedi.sav'
 .
DATASET CLOSE allmedi
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atallmedi.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpvisid F10.0
 mnpcvpid F10.0
 mnpvisno F10.0
 mnpvispdt DATE11
 mnpvisfdt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 no_more_meds F2.0
 med_family A15
 med_product A16
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpvisid 'Visit-ID'
 mnpcvpid 'Patient visit-ID'
 mnpvisno'Visit sequence'
 mnpvispdt 'Planned date of visit'
 mnpvisfdt 'Date of first data entry in visit'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 no_more_meds 'No further medication'
 med_family 'Family'
 med_product 'Product'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS no_more_meds
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atallmedi
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atallmedi.sav'
 .
DATASET CLOSE atallmedi
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/studyterminat.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 term_planned F2.0
 term_toxicity F2.0
 term_death F2.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 term_planned 'Planned'
 term_toxicity 'Toxicity'
 term_death 'Death'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS term_planned
 0 'no'
 1 'yes'
 .
VALUE LABELS term_toxicity
 0 'no'
 1 'yes'
 .
VALUE LABELS term_death
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME studyterminat
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/studyterminat.sav'
 .
DATASET CLOSE studyterminat
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atstudyterminat.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 term_planned F2.0
 term_toxicity F2.0
 term_death F2.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 term_planned 'Planned'
 term_toxicity 'Toxicity'
 term_death 'Death'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS term_planned
 0 'no'
 1 'yes'
 .
VALUE LABELS term_toxicity
 0 'no'
 1 'yes'
 .
VALUE LABELS term_death
 0 'no'
 1 'yes'
 .
CACHE.
EXECUTE.
DATASET NAME atstudyterminat
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atstudyterminat.sav'
 .
DATASET CLOSE atstudyterminat
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/ae.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpaeid F10.0
 mnpaedate DATETIME23.2
 mnpaeno F10.0
 mnpaefuid F10.0
 mnpaefudt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 ae_description A540
 ae_onset_date A8
 ae_onset_time A4
 ae_ongoing F10.0
 ae_end_date A8
 ae_end_time A4
 ae_is_sae F10.0
 ae_intensity F10.0
 ae_drug_relation F10.0
 ae_frequency F10.0
 ae_action F10.0
 ae_action_spec A540
 ae_outcome F10.0
 ae_outcome_spec A540
 notes A540
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpaeid 'Adverse Event-ID'
 mnpaedate 'Adverse Event date'
 mnpaeno 'Adverse Event case number'
 mnpaefuid 'Adverse Event Follow-up-ID'
 mnpaefudt 'Adverse Event Follow-up date'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 ae_description 'Description of Adverse Event'
 ae_onset_date 'Onset of AE'
 ae_onset_time 'Timepoints'
 ae_ongoing 'Ongoing'
 ae_end_date 'End of AE'
 ae_end_time 'Timepoints'
 ae_is_sae 'Is an SAE'
 ae_intensity 'Intensity'
 ae_drug_relation 'Relation to study'
 ae_frequency 'Frequency'
 ae_action 'Action taken'
 ae_action_spec 'Specify therapy / concomitant medication / Comments'
 ae_outcome 'Outcome'
 ae_outcome_spec 'If others, please specify'
 notes 'Notes'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS ae_ongoing
 1 'yes'
 0 'no'
 .
VALUE LABELS ae_is_sae
 1 'yes'
 0 'no'
 .
VALUE LABELS ae_intensity
 1 'mild (tolerable)'
 2 'moderate (interferes w. daily activ.)'
 3 'severe (daily activities impossible)'
 .
VALUE LABELS ae_drug_relation
 1 'unrelated'
 2 'unlikely'
 3 'possible'
 4 'probable'
 5 'definitely'
 6 'not assessable'
 .
VALUE LABELS ae_frequency
 1 'single episode'
 2 'intermittent'
 3 'continuous'
 .
VALUE LABELS ae_action
 1 'none'
 2 'non drug therapy'
 3 'concomitant medication'
 6 'study discontinued'
 .
VALUE LABELS ae_outcome
 1 'resolved without sequel'
 2 'resolved with sequel'
 3 'ongoing'
 4 'unknown'
 5 'others'
 .
CACHE.
EXECUTE.
DATASET NAME ae
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/ae.sav'
 .
DATASET CLOSE ae
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atae.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpaeid F10.0
 mnpaedate DATETIME23.2
 mnpaeno F10.0
 mnpaefuid F10.0
 mnpaefudt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 ae_description A540
 ae_onset_date A8
 ae_onset_time A4
 ae_ongoing F10.0
 ae_end_date A8
 ae_end_time A4
 ae_is_sae F10.0
 ae_intensity F10.0
 ae_drug_relation F10.0
 ae_frequency F10.0
 ae_action F10.0
 ae_action_spec A540
 ae_outcome F10.0
 ae_outcome_spec A540
 notes A540
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpaeid 'Adverse Event-ID'
 mnpaedate 'Adverse Event date'
 mnpaeno 'Adverse Event case number'
 mnpaefuid 'Adverse Event Follow-up-ID'
 mnpaefudt 'Adverse Event Follow-up date'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 ae_description 'Description of Adverse Event'
 ae_onset_date 'Onset of AE'
 ae_onset_time 'Timepoints'
 ae_ongoing 'Ongoing'
 ae_end_date 'End of AE'
 ae_end_time 'Timepoints'
 ae_is_sae 'Is an SAE'
 ae_intensity 'Intensity'
 ae_drug_relation 'Relation to study'
 ae_frequency 'Frequency'
 ae_action 'Action taken'
 ae_action_spec 'Specify therapy / concomitant medication / Comments'
 ae_outcome 'Outcome'
 ae_outcome_spec 'If others, please specify'
 notes 'Notes'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS ae_ongoing
 1 'yes'
 0 'no'
 .
VALUE LABELS ae_is_sae
 1 'yes'
 0 'no'
 .
VALUE LABELS ae_intensity
 1 'mild (tolerable)'
 2 'moderate (interferes w. daily activ.)'
 3 'severe (daily activities impossible)'
 .
VALUE LABELS ae_drug_relation
 1 'unrelated'
 2 'unlikely'
 3 'possible'
 4 'probable'
 5 'definitely'
 6 'not assessable'
 .
VALUE LABELS ae_frequency
 1 'single episode'
 2 'intermittent'
 3 'continuous'
 .
VALUE LABELS ae_action
 1 'none'
 2 'non drug therapy'
 3 'concomitant medication'
 6 'study discontinued'
 .
VALUE LABELS ae_outcome
 1 'resolved without sequel'
 2 'resolved with sequel'
 3 'ongoing'
 4 'unknown'
 5 'others'
 .
CACHE.
EXECUTE.
DATASET NAME atae
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atae.sav'
 .
DATASET CLOSE atae
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/sae.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpaeid F10.0
 mnpaedate DATETIME23.2
 mnpaeno F10.0
 mnpaefuid F10.0
 mnpaefudt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 sae_description A540
 sae_onset_date A8
 sae_onset_time A4
 sae_ongoing F10.0
 sae_end_date A8
 sae_end_time A4
 sae_intensity F10.0
 sae_drug_relation F10.0
 sae_frequency F10.0
 sae_action F10.0
 sae_action_spec A540
 sae_outcome F10.0
 sae_outcome_spec A540
 notes A540
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpaeid 'Adverse Event-ID'
 mnpaedate 'Adverse Event date'
 mnpaeno 'Adverse Event case number'
 mnpaefuid 'Adverse Event Follow-up-ID'
 mnpaefudt 'Adverse Event Follow-up date'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 sae_description 'Description of Serious Adverse Event'
 sae_onset_date 'Onset of SAE'
 sae_onset_time 'Timepoints'
 sae_ongoing 'Ongoing'
 sae_end_date 'End of SAE'
 sae_end_time 'Timepoints'
 sae_intensity 'Intensity'
 sae_drug_relation 'Relation to study'
 sae_frequency 'Frequency'
 sae_action 'Action taken'
 sae_action_spec 'Specify therapy / concomitant medication / Comments'
 sae_outcome 'Outcome'
 sae_outcome_spec 'If others, please specify'
 notes 'Notes'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS sae_ongoing
 1 'yes'
 0 'no'
 .
VALUE LABELS sae_intensity
 1 'mild (tolerable)'
 2 'moderate (interferes w. daily activ.)'
 3 'severe (daily activities impossible)'
 .
VALUE LABELS sae_drug_relation
 1 'unrelated'
 2 'unlikely'
 3 'possible'
 4 'probable'
 5 'definitely'
 6 'not assessable'
 .
VALUE LABELS sae_frequency
 1 'single episode'
 2 'intermittent'
 3 'continuous'
 .
VALUE LABELS sae_action
 1 'none'
 2 'non drug therapy'
 3 'concomitant medication'
 6 'study discontinued'
 .
VALUE LABELS sae_outcome
 1 'resolved without sequel'
 2 'resolved with sequel'
 3 'ongoing'
 4 'unknown'
 5 'others'
 .
CACHE.
EXECUTE.
DATASET NAME sae
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/sae.sav'
 .
DATASET CLOSE sae
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atsae.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpatdocid F10.0
 mnplastedit DATETIME23.2
 mnpptnid F10.0
 mnpaeid F10.0
 mnpaedate DATETIME23.2
 mnpaeno F10.0
 mnpaefuid F10.0
 mnpaefudt DATETIME23.2
 mnpfs0 F2.0
 mnpfs1 F2.0
 mnpfs2 F2.0
 mnpfs3 F2.0
 mnpfcs0 F2.0
 mnpfcs1 F2.0
 mnpfcs2 F2.0
 mnpfcs3 F2.0
 mnpfsqa F2.0
 mnpfsct F2.0
 mnphide F2.0
 sigstatus F2.0
 sigreason A200
 mnpvsno F10.0
 mnpvslbl A30
 sae_description A540
 sae_onset_date A8
 sae_onset_time A4
 sae_ongoing F10.0
 sae_end_date A8
 sae_end_time A4
 sae_intensity F10.0
 sae_drug_relation F10.0
 sae_frequency F10.0
 sae_action F10.0
 sae_action_spec A540
 sae_outcome F10.0
 sae_outcome_spec A540
 notes A540
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid 'Document-ID'
 mnpatdocid 'ATDocument-ID'
 mnplastedit 'Date of last edit'
 mnpptnid 'Participant-ID'
 mnpaeid 'Adverse Event-ID'
 mnpaedate 'Adverse Event date'
 mnpaeno 'Adverse Event case number'
 mnpaefuid 'Adverse Event Follow-up-ID'
 mnpaefudt 'Adverse Event Follow-up date'
 mnpfs0 'Form status (Review A)'
 mnpfs1 'Form status (Review B)'
 mnpfs2 'Form status (Freeze)'
 mnpfs3 'Form status (System-Freeze)'
 mnpfcs0 'Form completion status'
 mnpfcs1 'Form validation status (error)'
 mnpfcs2 'Form validation status (warning)'
 mnpfcs3 'Data entry complete status'
 mnpfsqa 'Form status Queries'
 mnpfsct 'Form status Comments'
 mnphide 'hidden in DataCapture'
 sigstatus 'Signature / storage type'
 sigreason 'Reason for modification'
 mnpvsno 'Version number'
 mnpvslbl 'Version label'
 sae_description 'Description of Serious Adverse Event'
 sae_onset_date 'Onset of SAE'
 sae_onset_time 'Timepoints'
 sae_ongoing 'Ongoing'
 sae_end_date 'End of SAE'
 sae_end_time 'Timepoints'
 sae_intensity 'Intensity'
 sae_drug_relation 'Relation to study'
 sae_frequency 'Frequency'
 sae_action 'Action taken'
 sae_action_spec 'Specify therapy / concomitant medication / Comments'
 sae_outcome 'Outcome'
 sae_outcome_spec 'If others, please specify'
 notes 'Notes'
 .
VALUE LABELS mnpptnid
 381 'Patrick Wright'
 .
VALUE LABELS sigstatus
 1 'Data edited'
 2 'Review A performed'
 3 'Review B performed'
 4 'Comment added'
 5 'Query added'
 6 'Query answered'
 7 'Form manually frozen'
 8 'Form unfrozen'
 9 'Source data verified'
 10 'Review A revoked'
 11 'Query resolved'
 12 'Data entry completed'
 13 'Data modified'
 14 'Form frozen'
 15 'Data imported'
 16 'Reopen data entry'
 17 'query withdrawn'
 19 'DDE entry'
 20 'DDE entry completed'
 21 'DDE entry reopened'
 22 'DDE comparison finished'
 23 'DDE entry corrected'
 24 'Data revalidated'
 25 'Data corrected'
 26 'Deviation created'
 27 'Deviation assessed'
 28 'Deviation reviewed'
 29 'Deviation edited'
 30 'Deviation withdrawn'
 31 'Data edited and queries transferred'
 32 'Data entry completed and queries transferred'
 .
VALUE LABELS mnpfcs0
 0 'empty'
 2 'partly filled'
 4 'completely filled'
 .
VALUE LABELS mnpfcs1
 0 ''
 1 'with errors'
 .
VALUE LABELS mnpfcs2
 0 ''
 1 'with warnings'
 .
VALUE LABELS mnpfcs3
 0 ''
 1 'data entry complete'
 .
VALUE LABELS mnpfs0
 0 ''
 1 'review (A)'
 .
VALUE LABELS mnpfs1
 0 ''
 1 'review (B)'
 .
VALUE LABELS mnpfs2
 0 ''
 1 'manual freeze'
 .
VALUE LABELS mnpfs3
 0 ''
 1 'rule-based freeze'
 .
VALUE LABELS mnpfsqa
 0 'without query'
 1 'with open query'
 2 'with answered query'
 4 'all queries resolved'
 .
VALUE LABELS mnpfsct
 0 ''
 1 'with comment'
 .
VALUE LABELS mnphide
 0 'no'
 1 'yes'
 .
VALUE LABELS sae_ongoing
 1 'yes'
 0 'no'
 .
VALUE LABELS sae_intensity
 1 'mild (tolerable)'
 2 'moderate (interferes w. daily activ.)'
 3 'severe (daily activities impossible)'
 .
VALUE LABELS sae_drug_relation
 1 'unrelated'
 2 'unlikely'
 3 'possible'
 4 'probable'
 5 'definitely'
 6 'not assessable'
 .
VALUE LABELS sae_frequency
 1 'single episode'
 2 'intermittent'
 3 'continuous'
 .
VALUE LABELS sae_action
 1 'none'
 2 'non drug therapy'
 3 'concomitant medication'
 6 'study discontinued'
 .
VALUE LABELS sae_outcome
 1 'resolved without sequel'
 2 'resolved with sequel'
 3 'ongoing'
 4 'unknown'
 5 'others'
 .
CACHE.
EXECUTE.
DATASET NAME atsae
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atsae.sav'
 .
DATASET CLOSE atsae
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/esurgeries.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpdocid F10.0
 mnpsubdocid F10.0
 fgid F10.0
 position F10.0
 surgery_type F10.0
 surgery_organ F10.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpdocid'Parent document-ID'
 mnpsubdocid 'Subdocument-ID'
 fgid 'Question-ID of Repetition'
 position 'Position in Repetition'
 surgery_type 'Type'
 surgery_organ 'Organ'
 .
VALUE LABELS surgery_type
 1 'Elective'
 2 'Emergency'
 3 'Re-operation'
 .
VALUE LABELS surgery_organ
 1 'Stomach'
 2 'Stomach (recurrent perforation)'
 3 'Intestines'
 4 'Intestines (recurrent perforation)'
 5 'Pancreas'
 6 'Liver / Biliary tract'
 7 'Kidney / Urinary tract'
 8 'Heart'
 9 'Lung'
 10 'Intraabdominal / intrathoracic vessels'
 11 'Other'
 .
CACHE.
EXECUTE.
DATASET NAME esurgeries
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/esurgeries.sav'
 .
DATASET CLOSE esurgeries
 .

GET DATA 
 /TYPE = TXT 
 /FILE = 'dat/atesurgeries.txt'
 /DELCASE = LINE
 /DELIMITERS = ","
 /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
 /VARIABLES = 
 mnppid F10.0
 mnpatdocid F10.0
 mnpatsubdocid F10.0
 fgid F10.0
 position F10.0
 surgery_type F10.0
 surgery_organ F10.0
 .
VARIABLE LABELS
 mnppid 'Patient-ID'
 mnpatdocid'Parent ATDocument-ID'
 mnpatsubdocid 'ATSubdocument-ID'
 fgid 'Question-ID of Repetition'
 position 'Position in Repetition'
 surgery_type 'Type'
 surgery_organ 'Organ'
 .
VALUE LABELS surgery_type
 1 'Elective'
 2 'Emergency'
 3 'Re-operation'
 .
VALUE LABELS surgery_organ
 1 'Stomach'
 2 'Stomach (recurrent perforation)'
 3 'Intestines'
 4 'Intestines (recurrent perforation)'
 5 'Pancreas'
 6 'Liver / Biliary tract'
 7 'Kidney / Urinary tract'
 8 'Heart'
 9 'Lung'
 10 'Intraabdominal / intrathoracic vessels'
 11 'Other'
 .
CACHE.
EXECUTE.
DATASET NAME atesurgeries
 WINDOW = FRONT
 .
SAVE OUTFILE='dat/atesurgeries.sav'
 .
DATASET CLOSE atesurgeries
 .

* end of file *.
