/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DBConnector {
    private Connection con = null;
    private boolean isConnected;

    public DBConnector(Connection con) {
        this.con = con;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public DBConnector(String url, String dbUser, String dbPassword) {
        this.createTempConnection(url, dbUser, dbPassword);
    }

    public void createTables(String tname, ArrayList<String> fields, ArrayList<String> types) {
        try {
            String query = "create Table " + tname + " ( ";
            int i = 0;
            while (i < fields.size()) {
                query = String.valueOf(query) + fields.get(i) + " " + types.get(i) + ",";
                ++i;
            }
            query = String.valueOf(query) + "Primary key (" + fields.get(0) + "));";
            Statement stmt = this.con.createStatement();
            stmt.execute(query);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createTemporaryTable(String tname, String targetTable, ArrayList<String> list) {
        try {
            String query = "create temporary Table " + tname + " as select ";
            int index = 0;
            while (index < list.size()) {
                query = String.valueOf(query) + list.get(index);
                if (index < list.size() - 1) {
                    query = String.valueOf(query) + ", ";
                }
                ++index;
            }
            query = String.valueOf(query) + " from " + targetTable + ";";
            Statement stmt = this.con.createStatement();
            stmt.execute(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet getValue(String tname, ArrayList<String> fields) {
        String query = "select ";
        int index = 0;
        while (index < fields.size()) {
            query = String.valueOf(query) + "`" + fields.get(index) + "`";
            if (index < fields.size() - 1) {
                query = String.valueOf(query) + ", ";
            }
            ++index;
        }
        query = String.valueOf(query) + " from " + tname + ";";
        return this.query(query);
    }

    public ResultSet getValues(String str) {
        String query = "select * from " + str;
        return this.query(query);
    }

    public void insertValue(String table, String que) {
        String query = "Insert into " + table + " Values (" + que + ");";
        try {
            Statement stmt = this.con.createStatement();
            stmt.execute(query);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResultSet query(String query) {
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            return rs;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResultSet showColums(String str) {
        return this.query("show columns from " + str);
    }

    public ResultSet showDatabases() {
        String query = "show databases";
        return this.query(query);
    }

    public ResultSet showTables(String str) {
        String query = "show full Tables from " + str;
        return this.query(query);
    }

    private void createTempConnection(String jdbcURL, String dbUser, String dbPassword) {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.con = DriverManager.getConnection(jdbcURL, dbUser, dbPassword);
            this.isConnected = true;
        }
        catch (IllegalAccessException e) {
            this.isConnected = false;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            this.isConnected = false;
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            this.isConnected = false;
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.isConnected = false;
            e.printStackTrace();
        }
    }
}

