/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.Variable;

public class FailureBased<V extends Variable>
implements IMonitorContradiction,
VariableSelector<V> {
    private double currenFixNum;
    private final int varNum;
    private final Random ran;
    private final Solver solver;
    private final TIntArrayList bests = new TIntArrayList();
    private int currentVarIndex = -1;
    private final int scoreType;
    private final double[] failures;
    private final double[] AFL;
    private final double[] assignTimes;
    private final double[] lastFailure;

    public FailureBased(V[] vars, long seed, int sType) {
        this.ran = new Random(seed);
        this.solver = vars[0].getModel().getSolver();
        this.solver.plugMonitor(this);
        this.varNum = vars.length;
        if (sType > 4 || sType < 1) {
            if (this.solver.getModel().getSettings().warnUser()) {
                this.solver.log().white().println("Unknown score type of failure based search!!");
                this.solver.log().white().println("Please specify the score type between 1 - 4 !!");
                this.solver.log().white().println("1 -> FRB");
                this.solver.log().white().println("2 -> FRBA");
                this.solver.log().white().println("3 -> FLB");
                this.solver.log().white().println("4 -> FLBA");
                this.solver.log().white().println("Using the default score type 2 !!");
            }
            this.scoreType = 2;
        } else {
            this.scoreType = sType;
        }
        this.failures = new double[this.varNum];
        this.lastFailure = new double[this.varNum];
        this.AFL = new double[this.varNum];
        this.assignTimes = new double[this.varNum];
        if (this.scoreType == 1 || this.scoreType == 2) {
            for (int i = 0; i < this.varNum; ++i) {
                this.failures[i] = 0.5;
                this.assignTimes[i] = 1.0;
            }
        }
    }

    @Override
    public V getVariable(V[] vars) {
        this.currenFixNum = 0.0;
        V best = null;
        this.bests.resetQuick();
        double w = Double.NEGATIVE_INFINITY;
        for (int idx = 0; idx < this.varNum; ++idx) {
            int dsize = vars[idx].getDomainSize();
            if (dsize > 1) {
                double weight = this.weight(idx, dsize);
                if (w < weight) {
                    this.bests.resetQuick();
                    this.bests.add(idx);
                    w = weight;
                    continue;
                }
                if (w != weight) continue;
                this.bests.add(idx);
                continue;
            }
            this.currenFixNum += 1.0;
        }
        if (this.bests.size() > 0) {
            this.currentVarIndex = this.bests.get(this.ran.nextInt(this.bests.size()));
            best = vars[this.currentVarIndex];
            int n = this.currentVarIndex;
            this.assignTimes[n] = this.assignTimes[n] + 1.0;
        }
        return best;
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        if (this.currentVarIndex != -1) {
            this.lastFailure[this.currentVarIndex] = this.solver.getFailCount();
            double fail_length = this.currenFixNum + 1.0;
            double flInc = 1.0 / fail_length;
            int n = this.currentVarIndex;
            this.AFL[n] = this.AFL[n] + flInc;
            int n2 = this.currentVarIndex;
            this.failures[n2] = this.failures[n2] + 1.0;
            this.currentVarIndex = -1;
        }
    }

    protected double weight(int id, int ds) {
        double finalScore = 0.0;
        switch (this.scoreType) {
            case 1: {
                double fr = this.failures[id] / this.assignTimes[id];
                finalScore = fr / (double)ds;
                break;
            }
            case 2: {
                double FR = this.failures[id] / this.assignTimes[id];
                double A = 1.0 / ((double)this.solver.getFailCount() - this.lastFailure[id] + 1.0);
                finalScore = (FR + A) / (double)ds;
                break;
            }
            case 3: {
                finalScore = this.AFL[id] / (double)ds;
                break;
            }
            case 4: {
                double hs = 1.0 / ((double)this.solver.getFailCount() - this.lastFailure[id] + 1.0);
                finalScore = hs * this.AFL[id] / (double)ds;
            }
        }
        return finalScore;
    }

    @Override
    public boolean init() {
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return true;
    }

    @Override
    public void remove() {
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }
}

