/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class ConflictOrderingSearch<V extends Variable>
extends AbstractStrategy<V>
implements IMonitorContradiction {
    protected Model model;
    private final AbstractStrategy<V> mainStrategy;
    List<V> vars;
    private final TIntIntHashMap var2pos;
    TIntList prev;
    TIntList next;
    int pcft;
    protected Set<V> scope;

    public ConflictOrderingSearch(Model model, AbstractStrategy<V> mainStrategy) {
        super(mainStrategy.vars);
        this.model = model;
        this.mainStrategy = mainStrategy;
        this.vars = new ArrayList<V>();
        this.var2pos = new TIntIntHashMap(16, 0.5f, -1, -1);
        this.prev = new TIntArrayList();
        this.next = new TIntArrayList();
        this.pcft = -1;
        this.scope = new HashSet(Arrays.asList(mainStrategy.vars));
    }

    @Override
    public boolean init() {
        if (this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().plugMonitor(this);
        }
        return this.mainStrategy.init();
    }

    @Override
    public void remove() {
        this.mainStrategy.remove();
        if (this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().unplugMonitor(this);
        }
    }

    @Override
    public Decision<V> getDecision() {
        Decision<V> d;
        V decVar = this.firstNotInst();
        if (decVar != null && (d = this.mainStrategy.computeDecision(decVar)) != null) {
            return d;
        }
        return this.mainStrategy.getDecision();
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        Decision dec = this.model.getSolver().getDecisionPath().getLastDecision();
        if (dec != RootDecision.ROOT && this.scope.contains(dec.getDecisionVariable())) {
            this.stampIt(dec.getDecisionVariable());
        }
    }

    void stampIt(V cftVar) {
        int id = cftVar.getId();
        int pos = this.var2pos.get(id);
        if (pos == -1) {
            pos = this.vars.size();
            this.vars.add(cftVar);
            this.var2pos.put(id, pos);
            if (this.pcft > -1) {
                this.next.add(-1);
                this.next.set(this.pcft, pos);
                this.prev.add(this.pcft);
            } else {
                assert (pos == 0);
                this.prev.add(-1);
                this.next.add(-1);
            }
        } else if (pos != this.pcft) {
            int p = this.prev.get(pos);
            int n = this.next.get(pos);
            if (p > -1) {
                this.next.set(p, n);
            }
            this.next.set(this.pcft, pos);
            this.next.set(pos, -1);
            if (n > -1) {
                this.prev.set(n, p);
            }
            this.prev.set(pos, this.pcft);
        }
        this.pcft = pos;
    }

    V firstNotInst() {
        int p = this.pcft;
        while (p > -1) {
            Variable v = (Variable)this.vars.get(p);
            if (!v.isInstantiated()) {
                return (V)((Variable)this.vars.get(p));
            }
            p = this.prev.get(p);
        }
        return null;
    }

    boolean check() {
        boolean ok = true;
        int first = -1;
        for (int i = 0; i < this.vars.size() && ok; ++i) {
            int p = this.prev.get(i);
            int n = this.next.get(i);
            ok = i == this.pcft && n == -1 || this.prev.get(n) == i;
            ok &= p == -1 || this.next.get(p) == i;
            if (p != -1) continue;
            ok &= first == -1;
            first = i;
        }
        return ok;
    }
}

