/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

@Explained
public class PropAbsolute
extends Propagator<IntVar> {
    private final IntVar X;
    private final IntVar Y;
    private final boolean bothEnumerated;

    public PropAbsolute(IntVar X, IntVar Y) {
        super((Variable[])ArrayUtils.toArray(X, Y), (Priority)PropagatorPriority.BINARY, true);
        this.X = ((IntVar[])this.vars)[0];
        this.Y = ((IntVar[])this.vars)[1];
        this.bothEnumerated = X.hasEnumeratedDomain() && Y.hasEnumeratedDomain();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain() && ((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                return ESat.eval(((IntVar[])this.vars)[0].getValue() == Math.abs(((IntVar[])this.vars)[1].getValue()));
            }
            if (((IntVar[])this.vars)[1].getDomainSize() == 2 && ((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && ((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.TRUE;
            }
            if (!((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && !((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = |%s|", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.X.updateLowerBound(0, this, Reason.undef());
        this.setBounds();
        if (this.bothEnumerated) {
            this.enumeratedFiltering();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            if (varIdx == 1) {
                this.X.instantiateTo(Math.abs(this.Y.getValue()), this, this.lcg() ? Reason.r(this.Y.getValLit()) : Reason.undef());
                this.setPassive();
            } else if (this.Y.hasEnumeratedDomain()) {
                int val = this.X.getValue();
                this.Y.updateLowerBound(-val, this, this.lcg() ? Reason.r(this.X.getValLit()) : Reason.undef());
                this.Y.updateUpperBound(val, this, this.lcg() ? Reason.r(this.X.getValLit()) : Reason.undef());
                int v = -(--val);
                while (v <= val) {
                    this.Y.removeValue(v, this, this.lcg() ? Reason.r(this.X.getValLit()) : Reason.undef());
                    v = this.Y.nextValue(v);
                }
                this.setPassive();
            } else {
                this.setBounds();
            }
        } else {
            if (IntEventType.isBound(mask)) {
                this.setBounds();
            }
            if (IntEventType.isRemove(mask) && this.bothEnumerated) {
                this.enumeratedFiltering();
            }
        }
    }

    private void setBounds() throws ContradictionException {
        int max = this.X.getUB();
        int min = this.X.getLB();
        this.Y.updateLowerBound(-max, this, this.lcg() ? Reason.r(this.X.getMaxLit()) : Reason.undef());
        this.Y.updateUpperBound(max, this, this.lcg() ? Reason.r(this.X.getMaxLit()) : Reason.undef());
        int v = 1 - min;
        while (v <= min - 1) {
            this.Y.removeValue(v, this, this.lcg() ? Reason.r(this.X.getMinLit()) : Reason.undef());
            v = this.Y.nextValue(v);
        }
        int prevLB = this.X.getLB();
        int prevUB = this.X.getUB();
        min = this.Y.getLB();
        max = this.Y.getUB();
        if (max <= 0) {
            this.X.updateLowerBound(-max, this, this.lcg() ? Reason.r(this.Y.getMaxLit()) : Reason.undef());
            this.X.updateUpperBound(-min, this, this.lcg() ? Reason.r(this.Y.getMinLit(), this.Y.getMaxLit()) : Reason.undef());
        } else if (min >= 0) {
            this.X.updateLowerBound(min, this, this.lcg() ? Reason.r(this.Y.getMinLit()) : Reason.undef());
            this.X.updateUpperBound(max, this, this.lcg() ? Reason.r(this.Y.getMinLit(), this.Y.getMaxLit()) : Reason.undef());
        } else {
            if (this.Y.hasEnumeratedDomain() && !this.lcg()) {
                int mP = this.Y.nextValue(-1);
                int mN = -this.Y.previousValue(1);
                this.X.updateLowerBound(Math.min(mP, mN), (ICause)this);
            }
            if (max >= -min) {
                this.X.updateLowerBound(-max, this, this.lcg() ? Reason.r(this.Y.getMaxLit()) : Reason.undef());
            } else {
                this.X.updateLowerBound(min, this, this.lcg() ? Reason.r(this.Y.getMinLit()) : Reason.undef());
            }
        }
        if (prevLB != this.X.getLB() || prevUB != this.X.getUB()) {
            this.setBounds();
        }
    }

    private void enumeratedFiltering() throws ContradictionException {
        int min = this.X.getLB();
        int max = this.X.getUB();
        int v = min;
        while (v <= max) {
            if (!this.Y.contains(v) && !this.Y.contains(-v)) {
                this.X.removeValue(v, this, this.lcg() ? Reason.r(this.Y.getLit(v, 1), this.Y.getLit(-v, 1)) : Reason.undef());
            }
            v = this.X.nextValue(v);
        }
        min = this.Y.getLB();
        max = this.Y.getUB();
        v = min;
        while (v <= max) {
            if (!this.X.contains(Math.abs(v))) {
                this.Y.removeValue(v, this, this.lcg() ? Reason.r(this.X.getLit(Math.abs(v), 1)) : Reason.undef());
            }
            v = this.Y.nextValue(v);
        }
    }
}

