/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar;

import java.io.Serializable;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.result.BooleanResult;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class DescriptorValue
implements Serializable {
    private static final long serialVersionUID = -5672896059814842972L;
    private final DescriptorSpecification specification;
    private final String[] parameterNames;
    private final Object[] parameterSettings;
    private final IDescriptorResult value;
    private String[] descriptorNames;
    private final Exception exception;

    public DescriptorValue(DescriptorSpecification specification, String[] parameterNames, Object[] parameterSettings, IDescriptorResult value, String[] descriptorNames) {
        this(specification, parameterNames, parameterSettings, value, descriptorNames, null);
    }

    public DescriptorValue(DescriptorSpecification specification, String[] parameterNames, Object[] parameterSettings, IDescriptorResult value, String[] descriptorNames, Exception exception) {
        this.specification = specification;
        this.parameterNames = parameterNames;
        this.parameterSettings = parameterSettings;
        this.value = value;
        this.descriptorNames = descriptorNames;
        this.exception = exception;
    }

    public DescriptorSpecification getSpecification() {
        return this.specification;
    }

    public Object[] getParameters() {
        return this.parameterSettings;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public IDescriptorResult getValue() {
        return this.value;
    }

    public Exception getException() {
        return this.exception;
    }

    public String[] getNames() {
        if (this.descriptorNames == null || this.descriptorNames.length == 0) {
            String title = this.specification.getImplementationTitle();
            if (this.value instanceof BooleanResult || this.value instanceof DoubleResult || this.value instanceof IntegerResult) {
                this.descriptorNames = new String[1];
                this.descriptorNames[0] = title;
            } else {
                int ndesc = 0;
                if (this.value instanceof DoubleArrayResult) {
                    ndesc = this.value.length();
                } else if (this.value instanceof IntegerArrayResult) {
                    ndesc = this.value.length();
                }
                this.descriptorNames = new String[ndesc];
                for (int i = 0; i < ndesc; ++i) {
                    this.descriptorNames[i] = title + i;
                }
            }
        }
        return this.descriptorNames;
    }
}

