/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti.norta;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdistmulti.norta.NortaInitDisc;
import umontreal.iro.lecuyer.util.Misc;

public class NI2a
extends NortaInitDisc {
    private double h;
    private double delta;

    public NI2a(double rX, DiscreteDistributionInt dist1, DiscreteDistributionInt dist2, double tr, double h, double delta) {
        super(rX, dist1, dist2, tr);
        this.h = h;
        this.delta = delta;
        this.computeParams();
    }

    public double computeCorr() {
        double inew;
        double xnew;
        double dnew;
        double dmid;
        int i;
        double iold;
        double dold;
        double xold;
        int m;
        double gr;
        double[] x = new double[3];
        double[] y = new double[3];
        double[] c = new double[3];
        double xtemp = 0.0;
        double temp = 0.0;
        double d = 0.0;
        double b = 0.0;
        double h2 = 0.0;
        double hd3 = 0.0;
        double lrx = (this.integ(-1.0) - this.mu1 * this.mu2) / this.sd1 * this.sd2;
        double urx = (this.integ(1.0) - this.mu1 * this.mu2) / this.sd1 * this.sd2;
        double rho1 = 2.0 * Math.sin(Math.PI * this.rX / 6.0);
        double intg1 = this.integ(rho1);
        if (intg1 == (gr = this.rX * this.sd1 * this.sd2 + this.mu1 * this.mu2)) {
            return rho1;
        }
        if (intg1 < gr) {
            if (0.0 < this.rX && this.rX < 1.0) {
                d = 1.0 - this.delta - rho1;
            }
            if (-1.0 < this.rX && this.rX < 0.0) {
                d = -rho1;
            }
            m = (int)Math.ceil(d / (2.0 * this.h));
            this.h = d / (double)(2 * m);
            hd3 = this.h / 3.0;
            h2 = 2.0 * this.h;
            xold = rho1;
            dold = this.deriv(xold);
            iold = intg1;
            for (i = 1; i <= m; ++i) {
                dmid = this.deriv(xold + this.h);
                inew = iold + hd3 * (dold + 4.0 * dmid + (dnew = this.deriv(xnew = xold + h2)));
                if (inew >= gr) {
                    x[0] = xtemp;
                    x[1] = xold;
                    x[2] = xnew;
                    y[0] = temp;
                    y[1] = iold;
                    y[2] = inew;
                    Misc.interpol(2, x, y, c);
                    b = (c[2] * (xtemp + xold) - c[1] + Math.sqrt((c[1] - c[2] * (xtemp + xold)) * (c[1] - c[2] * (xtemp + xold)) - 4.0 * c[2] * (c[0] - c[1] * xtemp + c[2] * xtemp * xold - gr))) / (2.0 * c[2]);
                    return b;
                }
                xtemp = xold;
                temp = iold;
                xold = xnew;
                dold = dnew;
                iold = inew;
            }
            b = 1.0 - this.delta / 2.0;
        }
        if (intg1 > gr) {
            if (0.0 < this.rX && this.rX < 1.0) {
                d = rho1;
            }
            if (-1.0 < this.rX && this.rX < 0.0) {
                d = rho1 + 1.0 - this.delta;
            }
            m = (int)Math.ceil(d / (2.0 * this.h));
            this.h = d / (double)(2 * m);
            hd3 = this.h / 3.0;
            h2 = 2.0 * this.h;
            xold = rho1;
            dold = this.deriv(xold);
            iold = intg1;
            for (i = 1; i <= m; ++i) {
                dmid = this.deriv(xold - this.h);
                inew = iold - hd3 * (dold + 4.0 * dmid + (dnew = this.deriv(xnew = xold - h2)));
                if (inew <= gr) {
                    x[0] = xnew;
                    x[1] = xold;
                    x[2] = xtemp;
                    y[0] = inew;
                    y[1] = iold;
                    y[2] = temp;
                    Misc.interpol(2, x, y, c);
                    b = (c[2] * (xnew + xold) - c[1] + Math.sqrt((c[1] - c[2] * (xnew + xold)) * (c[1] - c[2] * (xnew + xold)) - 4.0 * c[2] * (c[0] - c[1] * xnew + c[2] * xnew * xold - gr))) / (2.0 * c[2]);
                    return b;
                }
                xtemp = xold;
                temp = iold;
                xold = xnew;
                dold = dnew;
                iold = inew;
            }
            b = -1.0 + this.delta / 2.0;
        }
        return b;
    }

    public String toString() {
        String desc = super.toString();
        desc = desc + "h :  " + this.h + "\n";
        desc = desc + " delta : " + this.delta + "\n";
        return desc;
    }
}

