## -----------------------------------------------------------------------------
require(cdfinv)
alpha  <- 0.05 # the confidence coefficient is 1-alpha
n      <- 6
sigma2 <- 4/n
y.obs  <- 3

cdfinv("norm","mean",y.obs)

## ----fig.align="center",fig.height=4,fig.width=4------------------------------
ci_plot(cdfinv("norm","mean",y.obs))

## -----------------------------------------------------------------------------
cdfinv("tmean","mean",3,s2=4.5,n=6) # here we pass extra arguments

## -----------------------------------------------------------------------------
alpha <- 0.025 # appropriate for two-sided interval bounds computed separately
y.obs <- 18
n     <- 5
k     <- 10
cdfinv("binom","prob",y.obs-1,lpb=0,upb=1,bound="lower",alpha=alpha,size=n*k)$bound
cdfinv("binom","prob",y.obs  ,lpb=0,upb=1,bound="upper",alpha=alpha,size=n*k)$bound

## -----------------------------------------------------------------------------
alpha <- 0.1
y.obs <- 28
n     <- 10
cdfinv("pois","lambda",y.obs-1,lpb=0,bound="lower",alpha=alpha)$bound / n

## -----------------------------------------------------------------------------
require(extraDistr)

cdfinv("hnorm","sigma",5,lpb=0)$bound

