/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.curvefitting;

import gov.nih.ncats.ifx.qhts.curvefitting.FittingResult;
import gov.nih.ncats.ifx.qhts.curvefitting.service.CurveFittingServiceImpl;

public class CurveClassFit3 {
    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: java CurveClassFit3 <conc> <resp> <classificationSD> <minYrange>");
            return;
        }
        double[] dArray = CurveClassFit3.parseDoubleArray(stringArray[0]);
        double[] dArray2 = CurveClassFit3.parseDoubleArray(stringArray[1]);
        double d = Double.parseDouble(stringArray[2]);
        double d2 = Double.parseDouble(stringArray[3]);
        String string = CurveClassFit3.performCurveFitting(dArray, dArray2, d, d2);
        System.out.println(string);
    }

    public static String performCurveFitting(double[] dArray, double[] dArray2, double d, double d2) {
        CurveFittingServiceImpl curveFittingServiceImpl = new CurveFittingServiceImpl();
        FittingResult fittingResult = curveFittingServiceImpl.doFit(CurveClassFit3.toDoubleArray(dArray), CurveClassFit3.toDoubleArray(dArray2), d, d2);
        return fittingResult.toString();
    }

    private static double[] parseDoubleArray(String string) {
        String[] stringArray = string.split("\\s+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    private static Double[] toDoubleArray(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }
}

