/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

import java.util.LinkedList;
import keel.Algorithms.Rule_Learning.Prism.Muestra;
import keel.Algorithms.Rule_Learning.Prism.Selector;
import keel.Dataset.Instance;

public class Complejo
implements Comparable {
    private LinkedList compl;
    private int clase;
    private int nClases;
    private int[] distrib;
    private double heuristica;
    private String[] nombreAtributos;

    public Complejo() {
    }

    public Complejo(int nClas) {
        this.compl = new LinkedList();
        this.nClases = nClas;
        this.distrib = new int[nClas];
        for (int i = 0; i < this.nClases; ++i) {
            this.distrib[i] = 0;
        }
    }

    public int compareTo(Object o) {
        Complejo c2 = (Complejo)o;
        int sal = 0;
        if (this.heuristica == c2.getHeuristica() && this.compl.size() == c2.size()) {
            sal = 0;
        } else if (this.heuristica == c2.getHeuristica() && this.compl.size() < c2.size()) {
            sal = -1;
        } else if (this.heuristica == c2.getHeuristica() && this.compl.size() > c2.size()) {
            sal = 1;
        } else if (this.heuristica > c2.getHeuristica()) {
            sal = -1;
        } else if (this.heuristica < c2.getHeuristica()) {
            sal = 1;
        }
        return sal;
    }

    public boolean esIgual(Complejo c) {
        boolean iguales = false;
        if (c.size() == this.compl.size()) {
            iguales = true;
            for (int i = 0; i < c.size() && iguales; ++i) {
                iguales = this.getSelector(i).compareTo(c.getSelector(i)) == 0;
            }
        }
        return iguales;
    }

    public void addSelector(Selector s) {
        this.compl.add(s);
    }

    public void removeSelector(Selector s) {
        this.compl.remove(s);
    }

    public void removeSelectorAtributo(int atributo) {
        for (int i = 0; i < this.compl.size(); ++i) {
            Selector s = (Selector)this.compl.get(i);
            int atrib = s.getAtributo();
            if (atrib != atributo) continue;
            this.compl.remove(s);
            --i;
        }
    }

    public void clear() {
        this.compl.clear();
    }

    public Selector getSelector(int indice) {
        return (Selector)this.compl.get(indice);
    }

    public int size() {
        return this.compl.size();
    }

    public int getNClases() {
        return this.nClases;
    }

    public int getClase() {
        return this.clase;
    }

    public void setClase(int clase) {
        this.clase = clase;
    }

    public void calculaLaplaciano() {
        double nc = this.distrib[this.clase];
        double ntot = 0.0;
        for (int i = 0; i < this.nClases; ++i) {
            ntot += (double)this.distrib[i];
        }
        this.heuristica = (nc + 1.0) / (ntot + (double)this.nClases);
    }

    public boolean reglaCubreInstancia(Instance instancia) {
        boolean cubierto = true;
        block3: for (int i = 0; i < this.size() && cubierto; ++i) {
            Selector s = this.getSelector(i);
            switch (s.getOperador()) {
                case 0: {
                    double[] valor = s.getValores();
                    cubierto = false;
                    for (int j = 0; j < valor.length && !cubierto; ++j) {
                        double cadena = instancia.getInputRealValues(s.getAtributo());
                        cubierto = cadena == valor[j];
                    }
                    continue block3;
                }
            }
        }
        return cubierto;
    }

    public boolean cubre(Muestra m) {
        boolean cubierto = true;
        double[] ejemplo = m.getMuest();
        block6: for (int i = 0; i < this.size() && cubierto; ++i) {
            Selector s = this.getSelector(i);
            switch (s.getOperador()) {
                case 0: {
                    double[] valor = s.getValores();
                    cubierto = false;
                    for (int j = 0; j < valor.length && !cubierto; ++j) {
                        cubierto = ejemplo[s.getAtributo()] == valor[j];
                    }
                    continue block6;
                }
                case 1: {
                    cubierto = ejemplo[s.getAtributo()] != s.getValor();
                    continue block6;
                }
                case 2: {
                    cubierto = ejemplo[s.getAtributo()] <= s.getValor();
                    continue block6;
                }
                case 3: {
                    cubierto = ejemplo[s.getAtributo()] > s.getValor();
                }
            }
        }
        return cubierto;
    }

    public double getHeuristica() {
        return this.heuristica;
    }

    public void setHeuristica(double heu) {
        this.heuristica = heu;
    }

    public void borraDistrib() {
        for (int i = 0; i < this.nClases; ++i) {
            this.distrib[i] = 0;
        }
    }

    public void incrementaDistrib(int clase) {
        int n = clase;
        this.distrib[n] = this.distrib[n] + 1;
    }

    public int getDistribucionClase(int clase) {
        return this.distrib[clase];
    }

    public int[] getDistribucion() {
        return this.distrib;
    }

    public void print() {
        for (int x = 0; x < this.compl.size(); ++x) {
            Selector s = (Selector)this.compl.get(x);
            System.out.print("(" + this.nombreAtributos[s.getAtributo()] + " ");
            switch (s.getOperador()) {
                case 0: {
                    System.out.print("=");
                    break;
                }
                case 1: {
                    System.out.print("<>");
                    break;
                }
                case 2: {
                    System.out.print("<=");
                    break;
                }
                default: {
                    System.out.print(">");
                }
            }
            double[] valores = s.getValores();
            String[] valoresN = s.getValoresN();
            if (valoresN.length > 1) {
                System.out.print(" " + valoresN[0]);
                for (int i = 1; i < valoresN.length - 1; ++i) {
                    System.out.print(" \u00ef\u00bf\u00bd" + valoresN[i]);
                }
                System.out.print(" \u00ef\u00bf\u00bd" + valoresN[valoresN.length - 1] + ")");
            } else {
                System.out.print(" " + valoresN[0] + ")");
            }
            if (x >= this.compl.size() - 1) continue;
            System.out.print(" AND ");
        }
    }

    public String printString() {
        String cad = "";
        for (int x = 0; x < this.compl.size(); ++x) {
            Selector s = (Selector)this.compl.get(x);
            cad = cad + this.nombreAtributos[s.getAtributo()] + " ";
            switch (s.getOperador()) {
                case 0: {
                    cad = cad + "=";
                    break;
                }
                case 1: {
                    cad = cad + "<>";
                    break;
                }
                case 2: {
                    cad = cad + "<=";
                    break;
                }
                case 3: {
                    cad = cad + ">";
                }
            }
            double[] valores = s.getValores();
            String[] valoresN = s.getValoresN();
            if (valores.length > 1) {
                cad = cad + " " + valoresN[0];
                for (int i = 1; i < valores.length - 1; ++i) {
                    cad = cad + " \u00ef\u00bf\u00bd" + valoresN[i];
                }
                cad = cad + " \u00ef\u00bf\u00bd" + valoresN[valores.length - 1] + "";
            } else {
                cad = cad + " " + valoresN[0] + "";
            }
            if (x >= this.compl.size() - 1) continue;
            cad = cad + " AND ";
        }
        return cad;
    }

    public void printDistribucion() {
        System.out.print("   [");
        for (int i = 0; i < this.nClases; ++i) {
            System.out.print(" " + this.distrib[i]);
        }
        System.out.print("]");
    }

    public String printDistribucionString() {
        String cad = new String("   [");
        for (int i = 0; i < this.nClases; ++i) {
            cad = cad + " " + this.distrib[i];
        }
        cad = cad + "]";
        return cad;
    }

    public void adjuntaNombreAtributos(String[] atributos) {
        this.nombreAtributos = new String[atributos.length - 1];
        for (int i = 0; i < atributos.length - 1; ++i) {
            this.nombreAtributos[i] = atributos[i];
        }
    }
}

