/*
 * Decompiled with CFR 0.152.
 */
package keel.RunKeelTxt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class ExecuteAll {
    int step = 0;
    Execute exe;

    public ExecuteAll() {
        try {
            this.exe = new Execute("Executable");
            this.exe.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listDirectory(String directory, Vector result) {
        File file = new File(directory);
        File[] listado = file.listFiles();
        System.out.println("Processing directory [" + directory + "]");
        if (listado == null) {
            System.out.println("Invalid dir [" + directory + "]");
            return;
        }
        System.out.println("Processing " + listado.length + " files");
        for (int i = 0; i < listado.length; ++i) {
            System.out.println("processing " + listado[i].getName());
            if (listado[i].isFile()) {
                result.add(new String(directory + "/" + listado[i].getName()));
                continue;
            }
            this.listDirectory(directory + "/" + listado[i].getName(), result);
        }
    }

    class Execute
    extends Thread {
        Process pr;

        public Execute(String name) {
            super(name);
        }

        @Override
        public void run() {
            Document doc = new Document();
            try {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(new File("RunKeel.xml"));
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Execution XML file not found");
                return;
            }
            boolean para = false;
            List sentencias = doc.getRootElement().getChildren();
            for (int i = 0; i < sentencias.size() && !para; ++i) {
                String comando = "";
                List linea = ((Element)sentencias.get(i)).getChildren();
                for (int j = 0; j < linea.size(); ++j) {
                    comando = comando + ((Element)linea.get(j)).getText() + " ";
                }
                Date now = Calendar.getInstance().getTime();
                System.out.println("*** BEGIN OF EXPERIMENT " + now + "\n");
                System.out.print("\nExecuting: " + comando);
                try {
                    Runtime rt = Runtime.getRuntime();
                    Process proc = rt.exec(comando);
                    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
                    errorGobbler.start();
                    outputGobbler.start();
                    int exitVal = proc.waitFor();
                    now = Calendar.getInstance().getTime();
                    System.out.println("ExitValue: " + exitVal);
                    if (exitVal != 0) {
                        System.out.println("\n*** END OF EXPERIMENT " + now + "\n");
                        para = true;
                        continue;
                    }
                    now = Calendar.getInstance().getTime();
                    System.out.println("\n*** END OF EXPERIMENT " + now + "\n");
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (!para) {
                System.out.println("Experiment completed successfully");
            }
        }
    }

    public class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                isr.close();
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

