/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths;

public final class IntUtilities {
    public static int[] divisors(int n) {
        int[] tmp = new int[1 + n / 2];
        int nd = IntUtilities.divisors(n, tmp);
        int[] rslt = new int[nd];
        for (int i = 0; i < nd; ++i) {
            rslt[i] = tmp[i];
        }
        return rslt;
    }

    public static int divisors(int n, int[] buffer) {
        if (n == 1) {
            return 0;
        }
        int d = 1;
        int idx = 0;
        while (d * 2 <= n) {
            if (n % d == 0) {
                buffer[idx++] = d;
            }
            ++d;
        }
        return idx;
    }

    public static int gcd(int a, int b) {
        while (b > 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static int lcm(int a, int b) {
        return a * (b / IntUtilities.gcd(a, b));
    }

    private IntUtilities() {
    }
}

