/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.mapping;

import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import jd2.information.InformationMapping;
import lombok.Generated;

public final class LikelihoodStatisticsInfo {
    public static final String NP = "np";
    public static final String NEFFOBS = "neffectiveobs";
    public static final String ADJLVAL = "adjustedlogvalue";
    public static final String LVAL = "logvalue";
    public static final String SSQERR = "ssqerr";
    public static final String SER = "ser";
    public static final String SERML = "ser-ml";
    public static final String AIC = "aic";
    public static final String AICC = "aicc";
    public static final String BIC = "bic";
    public static final String BICC = "bicc";
    private static final InformationMapping<LikelihoodStatistics> MAPPING = new InformationMapping<LikelihoodStatistics>(LikelihoodStatistics.class);

    public static InformationMapping<LikelihoodStatistics> getMapping() {
        return MAPPING;
    }

    @Generated
    private LikelihoodStatisticsInfo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MAPPING.set(NEFFOBS, Integer.class, source -> source.effectiveObservationsCount);
        MAPPING.set(NP, Integer.class, source -> source.estimatedParametersCount);
        MAPPING.set(LVAL, Double.class, source -> source.logLikelihood);
        MAPPING.set(ADJLVAL, Double.class, source -> source.adjustedLogLikelihood);
        MAPPING.set(SSQERR, Double.class, source -> source.SsqErr);
        MAPPING.set(AIC, Double.class, source -> source.AIC);
        MAPPING.set(AICC, Double.class, source -> source.AICC);
        MAPPING.set(BIC, Double.class, source -> source.BIC);
        MAPPING.set(BICC, Double.class, source -> source.BICC);
        MAPPING.set(SER, Double.class, source -> Math.sqrt(source.SsqErr / (double)(source.effectiveObservationsCount - source.estimatedParametersCount + 1)));
        MAPPING.set(SERML, Double.class, source -> Math.sqrt(source.SsqErr / (double)source.effectiveObservationsCount));
    }
}

