/*
 * Decompiled with CFR 0.152.
 */
package indice;

import indice.Indice;
import javalain.math.Calcul;
import math.Matrice;
import umontreal.iro.lecuyer.probdist.NormalDist;

public final class Friedman
extends Indice {
    public Friedman(Matrice matrice) {
        super(matrice);
    }

    @Override
    public double calcul(double[] a) {
        ++this.nbEvaluation;
        double somme_j = 0.0;
        int m = 3;
        for (int j = 0; j < m; ++j) {
            double somme_i = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double[] Xi = this.matrice.ligne(i);
                somme_i += Friedman.polynome(j, 2.0 * NormalDist.cdf01((double)Calcul.produitScalaireVecteur(a, Xi)) - 1.0);
            }
            somme_j += (double)(2 * j + 1) / 2.0 * Calcul.pow2(somme_i / (double)this.N);
        }
        return somme_j;
    }

    private static double polynome(int j, double r) {
        double L = 0.0;
        if (j == 0) {
            L = 1.0;
        }
        if (j == 1) {
            L = r;
        }
        if (j == 2) {
            L = 0.5 * (3.0 * r * r - 1.0);
        }
        if (j > 2) {
            L = 1.0 / (double)j * ((double)(2 * j - 1) * r * Friedman.polynome(j - 1, r) - (double)(j - 1) * Friedman.polynome(j - 2, r));
        }
        return L;
    }
}

