/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class TAN
extends GlobalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1715277053980895298L;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "N. Friedman and D. Geiger and M. Goldszmidt");
        result.setValue(TechnicalInformation.Field.YEAR, "1997");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayesian network classifiers");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "29");
        result.setValue(TechnicalInformation.Field.NUMBER, "2-3");
        result.setValue(TechnicalInformation.Field.PAGES, "131-163");
        return result;
    }

    @Override
    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_BayesNet = bayesNet;
        this.m_bInitAsNaiveBayes = true;
        this.m_nMaxNrOfParents = 2;
        super.buildStructure(bayesNet, instances);
        int nNrOfAtts = instances.numAttributes();
        int nClassNode = instances.classIndex();
        int[] link1 = new int[nNrOfAtts - 1];
        int[] link2 = new int[nNrOfAtts - 1];
        boolean[] linked = new boolean[nNrOfAtts];
        int nBestLinkNode1 = -1;
        int nBestLinkNode2 = -1;
        double fBestDeltaScore = 0.0;
        int iLinkNode1 = 0;
        while (iLinkNode1 < nNrOfAtts) {
            if (iLinkNode1 != nClassNode) {
                int iLinkNode2 = 0;
                while (iLinkNode2 < nNrOfAtts) {
                    if (iLinkNode1 != iLinkNode2 && iLinkNode2 != nClassNode) {
                        double fScore = this.calcScoreWithExtraParent(iLinkNode1, iLinkNode2);
                        if (nBestLinkNode1 == -1 || fScore > fBestDeltaScore) {
                            fBestDeltaScore = fScore;
                            nBestLinkNode1 = iLinkNode2;
                            nBestLinkNode2 = iLinkNode1;
                        }
                    }
                    ++iLinkNode2;
                }
            }
            ++iLinkNode1;
        }
        link1[0] = nBestLinkNode1;
        link2[0] = nBestLinkNode2;
        linked[nBestLinkNode1] = true;
        linked[nBestLinkNode2] = true;
        int iLink = 1;
        while (iLink < nNrOfAtts - 2) {
            nBestLinkNode1 = -1;
            iLinkNode1 = 0;
            while (iLinkNode1 < nNrOfAtts) {
                if (iLinkNode1 != nClassNode) {
                    int iLinkNode2 = 0;
                    while (iLinkNode2 < nNrOfAtts) {
                        if (!(iLinkNode1 == iLinkNode2 || iLinkNode2 == nClassNode || !linked[iLinkNode1] && !linked[iLinkNode2] || linked[iLinkNode1] && linked[iLinkNode2])) {
                            double fScore = this.calcScoreWithExtraParent(iLinkNode1, iLinkNode2);
                            if (nBestLinkNode1 == -1 || fScore > fBestDeltaScore) {
                                fBestDeltaScore = fScore;
                                nBestLinkNode1 = iLinkNode2;
                                nBestLinkNode2 = iLinkNode1;
                            }
                        }
                        ++iLinkNode2;
                    }
                }
                ++iLinkNode1;
            }
            link1[iLink] = nBestLinkNode1;
            link2[iLink] = nBestLinkNode2;
            linked[nBestLinkNode1] = true;
            linked[nBestLinkNode2] = true;
            ++iLink;
        }
        boolean[] hasParent = new boolean[nNrOfAtts];
        int iLink2 = 0;
        while (iLink2 < nNrOfAtts - 2) {
            if (!hasParent[link1[iLink2]]) {
                bayesNet.getParentSet(link1[iLink2]).addParent(link2[iLink2], instances);
                hasParent[link1[iLink2]] = true;
            } else {
                if (hasParent[link2[iLink2]]) {
                    throw new Exception("Bug condition found: too many arrows");
                }
                bayesNet.getParentSet(link2[iLink2]).addParent(link1[iLink2], instances);
                hasParent[link2[iLink2]] = true;
            }
            ++iLink2;
        }
    }

    @Override
    public Enumeration listOptions() {
        return super.listOptions();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        return super.getOptions();
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm determines the maximum weight spanning tree and returns a Naive Bayes network augmented with a tree.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

