/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.data.AttributeType;
import java.util.ArrayList;

public abstract class BaseConfig {
    protected String basePath;
    protected String csvSeparator;
    protected ArrayList<AttributeType> attType;
    protected String targetAttribute = "XClass";
    protected String IDcolumnName;
    private String outputPathWithoutSuffix;
    private String outputPath;
    protected String dataPath;

    public String getCSVSeparator() {
        return this.csvSeparator;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    protected ArrayList<AttributeType> parseAttributeTypes(String[] types) {
        ArrayList<AttributeType> attTypes = new ArrayList<AttributeType>();
        for (int i = 0; i < types.length; ++i) {
            String type;
            int repeats = 1;
            int repeatFlagStart = types[i].indexOf(35);
            if (repeatFlagStart > -1) {
                repeats = Integer.parseInt(types[i].substring(repeatFlagStart + 1));
                type = types[i].substring(0, repeatFlagStart);
            } else {
                type = types[i];
            }
            for (int j = 1; j <= repeats; ++j) {
                attTypes.add(AttributeType.valueOf(this.normalizeType(type)));
            }
        }
        return attTypes;
    }

    private String normalizeType(String type) {
        if (type.equals("factor")) {
            return "nominal";
        }
        if (type.equals("logical")) {
            return "nominal";
        }
        if (type.equals("integer")) {
            return "numerical";
        }
        if (type.equals("numeric")) {
            return "numerical";
        }
        return type;
    }

    public ArrayList<AttributeType> getAttributeType() {
        return this.attType;
    }

    public String getTargetAttribute() {
        return this.targetAttribute;
    }

    public String getIDcolumnName() {
        return this.IDcolumnName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOutputPath(String suffix) {
        return this.outputPathWithoutSuffix + "." + suffix;
    }

    protected void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        this.outputPathWithoutSuffix = outputPath.substring(0, outputPath.lastIndexOf(46));
    }
}

