/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class RayleighDist
extends ContinuousDistribution {
    private double a;
    private double beta;

    public RayleighDist(double beta) {
        this.setParams(0.0, beta);
    }

    public RayleighDist(double a, double beta) {
        this.setParams(a, beta);
    }

    public double density(double x) {
        return RayleighDist.density(this.a, this.beta, x);
    }

    public double cdf(double x) {
        return RayleighDist.cdf(this.a, this.beta, x);
    }

    public double barF(double x) {
        return RayleighDist.barF(this.a, this.beta, x);
    }

    public double inverseF(double u) {
        return RayleighDist.inverseF(this.a, this.beta, u);
    }

    public double getMean() {
        return RayleighDist.getMean(this.a, this.beta);
    }

    public double getVariance() {
        return RayleighDist.getVariance(this.beta);
    }

    public double getStandardDeviation() {
        return RayleighDist.getStandardDeviation(this.beta);
    }

    public static double density(double a, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        double Z = (x - a) / beta;
        return Z / beta * Math.exp(-Z * Z / 2.0);
    }

    public static double density(double beta, double x) {
        return RayleighDist.density(0.0, beta, x);
    }

    public static double cdf(double a, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        double Z = (x - a) / beta;
        if (Z >= 10.0) {
            return 1.0;
        }
        return -Math.expm1(-Z * Z / 2.0);
    }

    public static double cdf(double beta, double x) {
        return RayleighDist.cdf(0.0, beta, x);
    }

    public static double barF(double a, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= a) {
            return 1.0;
        }
        double z = (x - a) / beta;
        if (z >= 44.0) {
            return 0.0;
        }
        return Math.exp(-z * z / 2.0);
    }

    public static double barF(double beta, double x) {
        return RayleighDist.barF(0.0, beta, x);
    }

    public static double inverseF(double a, double beta, double u) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u <= 0.0) {
            return a;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return a + beta * Math.sqrt(-2.0 * Math.log1p(-u));
    }

    public static double inverseF(double beta, double u) {
        return RayleighDist.inverseF(0.0, beta, u);
    }

    public static double[] getMLE(double[] x, int n, double a) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double somme = 0.0;
        for (int i = 0; i < n; ++i) {
            somme += (x[i] - a) * (x[i] - a);
        }
        double[] parametres = new double[]{Math.sqrt(somme / (2.0 * (double)n))};
        return parametres;
    }

    public static RayleighDist getInstanceFromMLE(double[] x, int n, double a) {
        double[] parameters = RayleighDist.getMLE(x, n, a);
        return new RayleighDist(parameters[0], parameters[1]);
    }

    public static double getMean(double a, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return a + beta * Math.sqrt(1.5707963267948966);
    }

    public static double getVariance(double beta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        return 0.42920367320510344 * beta * beta;
    }

    public static double getStandardDeviation(double beta) {
        return Math.sqrt(RayleighDist.getVariance(beta));
    }

    public double getA() {
        return this.a;
    }

    public double getSigma() {
        return this.beta;
    }

    public void setParams(double a, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.a = a;
        this.beta = beta;
        this.supportA = a;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", beta = " + this.beta;
    }
}

