/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.utils;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class Stat {
    private static double[] cof;
    private static double stp;
    private static double half;
    private static double one;
    private static double fpf;
    private static int[][] mwuTable;

    public static void main(String[] args) {
        double[] xs = new double[]{28.0, 27.0, 33.0, 23.0, 24.0, 17.0, 25.0, 23.0, 31.0, 23.0, 23.0, 22.0, 15.0};
        double[] ys = new double[]{14.0, 20.0, 16.0, 13.0, 18.0, 21.0, 23.0, 20.0, 14.0, 20.0, 20.0, 14.0, 11.0, 16.0, 13.0};
        double[][] xys = new double[][]{xs, ys};
        double p = Stat.kwRankTest(xys);
        System.out.println(p);
    }

    public static boolean mwuTest(double[] xs, double[] ys) {
        int n1 = xs.length;
        int n2 = ys.length;
        int[] rxs = new int[n1];
        int[] rys = new int[n2];
        int r = 1;
        while (true) {
            int i;
            double min = Double.MAX_VALUE;
            int s = -1;
            int p = -1;
            for (i = 0; i < n1; ++i) {
                if (rxs[i] != 0 || !(xs[i] <= min)) continue;
                min = xs[i];
                s = 1;
                p = i;
            }
            for (i = 0; i < n2; ++i) {
                if (rys[i] != 0 || !(ys[i] <= min)) continue;
                min = ys[i];
                s = 2;
                p = i;
            }
            if (s < 0) break;
            if (s == 1) {
                rxs[p] = r;
            } else {
                rys[p] = r;
            }
            ++r;
        }
        int sumr = 0;
        for (int i = 0; i < rxs.length; ++i) {
            sumr += rxs[i];
        }
        int u1 = n1 * n2 + n1 * (n1 + 1) / 2 - sumr;
        int u2 = n1 * n2 - u1;
        int u = Math.min(u1, u2);
        System.out.println(u + ":" + mwuTable[n1 - 1][n2 - 1]);
        return u < mwuTable[n1 - 1][n2 - 1];
    }

    public static double kwRankTest(double[][] xs) {
        int n = 0;
        for (int i = 0; i < xs.length; ++i) {
            n += xs[i].length;
        }
        double meanR = 0.5 * (double)(n + 1);
        int[][] rs = new int[xs.length][];
        for (int i = 0; i < xs.length; ++i) {
            rs[i] = new int[xs[i].length];
        }
        int r = 1;
        while (true) {
            int s = -1;
            int p = -1;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < xs.length; ++i) {
                for (int j = 0; j < xs[i].length; ++j) {
                    if (rs[i][j] != 0 || !(xs[i][j] <= min)) continue;
                    min = xs[i][j];
                    s = i;
                    p = j;
                }
            }
            if (s < 0) break;
            rs[s][p] = r++;
        }
        double[] meanRs = new double[rs.length];
        for (int i = 0; i < rs.length; ++i) {
            meanRs[i] = 0.0;
            for (int j = 0; j < rs[i].length; ++j) {
                int n2 = i;
                meanRs[n2] = meanRs[n2] + (double)rs[i][j];
            }
            int n3 = i;
            meanRs[n3] = meanRs[n3] / (double)rs[i].length;
        }
        double dk = 0.0;
        for (int i = 0; i < rs.length; ++i) {
            double delta = meanRs[i] - meanR;
            dk += (double)rs[i].length * delta * delta;
        }
        ChiSquaredDistribution cd = new ChiSquaredDistribution(xs.length - 1);
        double p = cd.cumulativeProbability(dk *= 12.0 / (double)(n * (n + 1)));
        return 1.0 - p;
    }

    public static double[] getP(double td) {
        double[] ps = new double[2];
        if (td < 1.642) {
            ps[0] = 0.2;
            ps[1] = 0.2;
        } else if (td >= 1.642 && td < 2.706) {
            ps[0] = 0.1;
            ps[1] = 0.2;
        } else if (td >= 2.706 && td < 3.841) {
            ps[0] = 0.05;
            ps[1] = 0.1;
        } else if (td >= 3.841 && td < 5.412) {
            ps[0] = 0.02;
            ps[1] = 0.05;
        } else if (td >= 5.412 && td < 6.635) {
            ps[0] = 0.01;
            ps[1] = 0.02;
        } else if (td >= 6.635 && td < 10.827) {
            ps[0] = 0.001;
            ps[1] = 0.01;
        } else {
            ps[0] = 0.001;
            ps[1] = 0.001;
        }
        return ps;
    }

    public static double[] linecorr(double[] x, double[] y) throws Exception {
        return Stat.linecorr(x, y, 0);
    }

    public static double[] linecorr(double[] x, double[] y, int delta) throws Exception {
        double[] values;
        int no = x.length - delta;
        double xm = 0.0;
        double ym = 0.0;
        for (int i = delta; i < no; ++i) {
            xm += x[i];
            ym += y[i - delta];
        }
        xm /= (double)no;
        ym /= (double)no;
        double lxx = 0.0;
        double lyy = 0.0;
        double lxy = 0.0;
        for (int i = delta; i < no; ++i) {
            lxx += (x[i] - xm) * (x[i] - xm);
            lyy += (y[i - delta] - ym) * (y[i - delta] - ym);
            lxy += (x[i] - xm) * (y[i - delta] - ym);
        }
        values = new double[]{lxy / Math.sqrt(lxx * lyy), lxy / lxx, ym - values[1] * xm};
        return values;
    }

    public static boolean[] data_mask(double[] x, double[] y) throws Exception {
        int no = x.length;
        boolean[] flags = new boolean[no];
        if (x.length == 2) {
            for (int i = 0; i < no; ++i) {
                flags[i] = true;
            }
            return flags;
        }
        double[] grad = new double[no];
        for (int i = 0; i < no - 1; ++i) {
            grad[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        grad[no - 1] = grad[no - 2];
        double[] sta = Stat.calcMeanStd(grad);
        for (int i = 0; i < no; ++i) {
            flags[i] = true;
            if (Math.abs(grad[i] - sta[0]) > 3.0 * sta[1]) {
                flags[i] = false;
            }
            System.out.println(sta[0] + ":" + sta[1] + ":" + grad[i] + ":" + Math.abs(grad[i] - sta[0]) / sta[1]);
            if (flags[i]) continue;
            System.out.println(sta[0] + ":" + sta[1] + ":" + grad[i] + ":" + Math.abs(grad[i] - sta[0]) / sta[1]);
            System.exit(1);
        }
        return flags;
    }

    public static double[] linecorr(double[] x, double[] y, boolean flag) throws Exception {
        double[] values;
        int no = x.length;
        Object flags = null;
        double xm = 0.0;
        double ym = 0.0;
        no = 0;
        for (int i = 0; i < x.length; ++i) {
            if (flags != null && flags[i] == false) continue;
            xm += x[i];
            ym += y[i];
            ++no;
        }
        xm /= (double)no;
        ym /= (double)no;
        double lxx = 0.0;
        double lyy = 0.0;
        double lxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (flags != null && flags[i] == false) continue;
            lxx += (x[i] - xm) * (x[i] - xm);
            lyy += (y[i] - ym) * (y[i] - ym);
            lxy += (x[i] - xm) * (y[i] - ym);
        }
        values = new double[]{lxy / Math.sqrt(lxx * lyy), lxy / lxx, ym - values[1] * xm};
        return values;
    }

    public static double[] linefit(double[] fits, double[] x) throws Exception {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i] * fits[1] + fits[2];
        }
        return y;
    }

    public static double linefit(double[] fits, double x) throws Exception {
        return x * fits[1] + fits[2];
    }

    public static double[] calcMeanStd(double[] x) throws Exception {
        return Stat.calcMeanStd(x, x.length);
    }

    public static double[] calcMeanStd(double[] x, int no) throws Exception {
        if (no < 0 || no > x.length) {
            no = x.length;
        }
        double xm = 0.0;
        for (int i = 0; i < no; ++i) {
            xm += x[i];
        }
        xm /= (double)no;
        double std = 0.0;
        for (int i = 0; i < no; ++i) {
            std += (x[i] - xm) * (x[i] - xm);
        }
        std = Math.sqrt(std / (double)no);
        double[] values = new double[]{xm, std};
        return values;
    }

    public static double sigOfCorr(double r, int n) {
        double tiny = 1.0E-6;
        double div_1 = 0.0;
        double div_2 = 0.0;
        double df = 0.0;
        double tt = 0.0;
        double pr = 0.0;
        if (n > 2) {
            div_1 = 1.0 + r + tiny;
            div_2 = 1.0 - r + tiny;
            df = n - 2;
            tt = r * Math.sqrt(df / (div_1 * div_2));
            pr = Stat.betai(0.5 * df, 0.5, df / (df + tt * tt));
        } else {
            pr = 1.0;
        }
        return pr;
    }

    public static double betai(double a, double b, double x) {
        double bt = 0.0;
        double pr = 0.0;
        if (x < 0.0 || x > 1.0) {
            return 1.0;
        }
        bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(Stat.gammln(a + b) - Stat.gammln(a) - Stat.gammln(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        pr = x < (a + 1.0) / (a + b + 2.0) ? bt * Stat.betacf(a, b, x) / a : 1.0 - bt * Stat.betacf(b, a, 1.0 - x) / b;
        return pr;
    }

    public static double betacf(double a, double b, double x) {
        int itmax = 100;
        double eps = 3.0E-7;
        double am = 1.0;
        double bm = 1.0;
        double az = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * x / qap;
        for (int m = 1; m <= itmax; ++m) {
            int em = m;
            int tem = em + em;
            double d = (double)em * (b - (double)m) * x / ((qam + (double)tem) * (a + (double)tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -(a + (double)em) * (qab + (double)em) * x / ((a + (double)tem) * (qap + (double)tem));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            double aold = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            if (!(Math.abs(az - aold) < eps * Math.abs(az))) continue;
            return az;
        }
        return az;
    }

    public static double gammln(double xx) {
        double result = 0.0;
        double x = 0.0;
        double tmp = 0.0;
        double ser = 0.0;
        x = xx - one;
        tmp = x + fpf;
        tmp = (x + half) * Math.log(tmp) - tmp;
        ser = one;
        for (int j = 0; j < 6; ++j) {
            ser += cof[j] / (x += one);
        }
        result = tmp + Math.log(stp * ser);
        return result;
    }

    public static double calcF(double df1, double df2, double f) {
        double x = df2 / (df1 * f + df2);
        double pi = Math.PI;
        double pj2 = 1.5707963267948966;
        if ((int)df1 % 2 == 0) {
            return Stat.calcF(1.0 - x, df2, df1 + df2 - 4.0, df2 - 2.0) * Math.pow(x, df2 / 2.0);
        }
        if ((int)df2 % 2 == 0) {
            return 1.0 - Stat.calcF(x, df1, df1 + df2 - 4.0, df1 - 2.0) * Math.pow(1.0 - x, df1 / 2.0);
        }
        double tan = Math.atan(Math.sqrt(df1 * f / df2));
        double a = tan / pj2;
        double sat = Math.sin(tan);
        double cot = Math.cos(tan);
        if (df2 > 1.0) {
            a += sat * cot * Stat.calcF(cot * cot, 2.0, df2 - 3.0, -1.0) / pj2;
        }
        if (df1 == 1.0) {
            return 1.0 - a;
        }
        double c = 4.0 * Stat.calcF(sat * sat, df2 + 1.0, df1 + df2 - 4.0, df2 - 2.0) * sat * Math.pow(cot, df2) / pi;
        if (df2 == 1.0) {
            return 1.0 - a + c / 2.0;
        }
        int k = 2;
        while ((double)k <= (df2 - 1.0) / 2.0) {
            c = c * (double)k / ((double)k - 0.5);
            ++k;
        }
        return 1.0 - a + c;
    }

    public static double calcF(double q, double i, double j, double b) {
        double zz;
        double z = zz = 1.0;
        for (double k = i; k <= j; k += 2.0) {
            zz = zz * q * k / (k - b);
            z += zz;
        }
        return z;
    }

    public static double calcGammaLn(double xx) {
        double[] cof = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739156, 0.00120858003, -5.36382E-6};
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.0;
        for (int j = 0; j < 6; ++j) {
            ser += cof[j] / (x += 1.0);
        }
        return -tmp + Math.log(2.50662827465 * ser);
    }

    public static double calcGamma(double x) {
        return Math.exp(Stat.calcGammaLn(x));
    }

    public static int factorial(int n) {
        int k = 1;
        for (int i = 1; i <= n; ++i) {
            k *= i;
        }
        return k;
    }

    public static double calcBeta(int p, int q) {
        return (double)(Stat.factorial(p - 1) * Stat.factorial(q - 1)) / (double)Stat.factorial(p + q - 1);
    }

    public static double doAnova(double[][] xs) throws Exception {
        double[] means = new double[xs.length];
        int no = 0;
        double mean = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            means[i] = 0.0;
            for (int j = 0; j < xs[i].length; ++j) {
                mean += xs[i][j];
                int n = i;
                means[n] = means[n] + xs[i][j];
                ++no;
            }
            int n = i;
            means[n] = means[n] / (double)xs[i].length;
        }
        mean /= (double)no;
        double sst = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            for (int j = 0; j < xs[i].length; ++j) {
                sst += (xs[i][j] - mean) * (xs[i][j] - mean);
            }
        }
        double ssb = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            ssb += (double)xs[i].length * (means[i] - mean) * (means[i] - mean);
        }
        double sgg = sst - ssb;
        double f = (ssb /= (double)(xs.length - 1)) / (sgg /= (double)(no - xs.length));
        double p = Stat.calcF(xs.length - 1, no - xs.length, f);
        return p;
    }

    static {
        int i;
        cof = null;
        stp = 2.50662827465;
        half = 0.5;
        one = 1.0;
        fpf = 5.5;
        cof = new double[6];
        Stat.cof[0] = 76.18009173;
        Stat.cof[1] = -86.50532033;
        Stat.cof[2] = 24.014909822;
        Stat.cof[3] = -1.231739516;
        Stat.cof[4] = 0.00120858003;
        Stat.cof[5] = -5.36382E-6;
        String mwuText = "2-8 0 0 0 0 1 1 1 1 1 2 2 2 2;";
        mwuText = mwuText + "3-5 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8;";
        mwuText = mwuText + "4-7 3 4 4 5 6 7 8 9 10 11 11 12 13 13;";
        mwuText = mwuText + "5-2 0 1 2 2 3 5 6 7 8 9 10 12 13 14 15 17 18 19 20;";
        mwuText = mwuText + "6-6 5 6 8 10 11 13 14 16 17 19 21 22 24 25 27;";
        mwuText = mwuText + "7-7 8 10 12 14 16 18 20 22 24 26 28 30 32 34;";
        mwuText = mwuText + "8-8 13 15 17 19 22 24 26 29 31 34 36 38 41;";
        mwuText = mwuText + "9-9 17 20 23 26 28 31 34 37 39 42 45 48;";
        mwuText = mwuText + "10-10 23 26 29 33 36 39 42 45 48 52 55;";
        mwuText = mwuText + "11-11 30 33 37 40 44 47 51 55 58 62;";
        mwuText = mwuText + "12-12 37 41 45 49 53 57 61 65 69;";
        mwuText = mwuText + "13-13 45 50 54 59 63 67 72 76;";
        mwuText = mwuText + "14-14 55 59 64 67 74 78 83;";
        mwuText = mwuText + "15-15 64 70 75 80 85 90;";
        mwuText = mwuText + "16-16 75 81 86 92 98;";
        mwuText = mwuText + "17-17 87 93 99 105;";
        mwuText = mwuText + "18-18 99 106 112;";
        mwuText = mwuText + "19-19 113 119;";
        mwuText = mwuText + "20-20 127";
        mwuTable = new int[20][20];
        String[] lines = mwuText.split(";");
        for (i = 0; i < lines.length; ++i) {
            String[] cols = lines[i].split(" ");
            String[] toks = cols[0].split("-");
            int r = Integer.parseInt(toks[0]) - 1;
            int c = Integer.parseInt(toks[1]) - 1;
            for (int j = 0; j < cols.length - 1; ++j) {
                Stat.mwuTable[r][c + j] = Integer.parseInt(cols[j + 1]);
            }
        }
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < i; ++j) {
                Stat.mwuTable[i][j] = mwuTable[j][i];
            }
        }
    }
}

