/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.List;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SendToPerspective", category="Flow", toolTipText="Send instances to a perspective (graphical environment only)", iconPath="weka/gui/knowledgeflow/icons/DiamondPlain.gif")
public class SendToPerspective
extends BaseStep {
    private static final long serialVersionUID = 7322550048407408819L;
    protected String m_perspectiveName = "";

    public void setPerspectiveName(String name) {
        this.m_perspectiveName = name;
    }

    public String getPerspectiveName() {
        return this.m_perspectiveName;
    }

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        if (this.getStepManager().getExecutionEnvironment().isHeadless()) {
            this.getStepManager().logWarning("Unable to send data to perspective due to execution in a headless environment.");
        } else if (this.m_perspectiveName == null || this.m_perspectiveName.length() == 0) {
            this.getStepManager().logWarning("No perspective specified");
        } else {
            List visiblePerspectives = (List)this.getStepManager().getExecutionEnvironment().getGraphicalEnvironmentCommandHandler().performCommand("getPerspectiveNames", new Object[0]);
            if (!visiblePerspectives.contains(this.m_perspectiveName)) {
                throw new WekaException("The perspective to send to '" + this.m_perspectiveName + "' does not seem to be available");
            }
            Instances toSend = (Instances)data.getPrimaryPayload();
            if (toSend != null) {
                this.getStepManager().getExecutionEnvironment().getGraphicalEnvironmentCommandHandler().performCommand("sendToPerspective", this.m_perspectiveName, toSend);
            }
        }
        this.getStepManager().finished();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0) {
            result.add("dataSet");
            result.add("trainingSet");
            result.add("testSet");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return null;
    }
}

