/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.ID3;

import keel.Algorithms.Decision_Trees.ID3.Attribute;
import keel.Algorithms.Decision_Trees.ID3.Dataset;

public class Itemset {
    protected Dataset dataset;
    protected double[] values;
    protected double weight;
    protected static final double MISSING_VALUE = Double.NaN;

    public Itemset(Itemset itemset) {
        this.values = itemset.values;
        this.weight = itemset.weight;
        this.dataset = null;
    }

    public Itemset(double w, double[] attributeValues) {
        this.values = attributeValues;
        this.weight = w;
        this.dataset = null;
    }

    public int classIndex() {
        if (this.dataset == null) {
            System.err.println("dataset in itemset is null");
            return -1;
        }
        return this.dataset.getClassIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        return this.isMissing(this.classIndex());
    }

    public double getClassValue() {
        if (this.classIndex() < 0) {
            System.err.println("dataset in itemset is null");
            return -1.0;
        }
        return this.getValue(this.classIndex());
    }

    public int numClasses() {
        if (this.dataset == null) {
            System.err.println("dataset in itemset is null");
            return -1;
        }
        return this.dataset.numClasses();
    }

    public Attribute getAttribute(int index) {
        if (this.dataset == null) {
            System.err.println("dataset in itemset is null");
            return null;
        }
        return this.dataset.getAttribute(index);
    }

    public void setValue(int index, double value) {
        double[] help = new double[this.values.length];
        System.arraycopy(this.values, 0, help, 0, this.values.length);
        this.values = help;
        this.values[index] = value;
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public final void setWeight(double w) {
        this.weight = w;
    }

    public final double getWeight() {
        return this.weight;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public final void setDataset(Dataset data) {
        this.dataset = data;
    }

    public boolean isMissing(int index) {
        return Double.isNaN(this.values[index]);
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static double getMissingValue() {
        return Double.NaN;
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        this.setMissing(this.classIndex());
    }

    public final void setMissing(int index) {
        this.setValue(index, Double.NaN);
    }

    public Object copy() {
        Itemset result = new Itemset(this);
        result.dataset = this.dataset;
        return result;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.dataset.numAttributes(); ++i) {
            Attribute att = this.dataset.getAttribute(i);
            result = att.isContinuous() ? result + att.name() + "=" + this.values[i] + "\n" : result + att.name() + "=" + att.value((int)this.values[i]) + "\n";
        }
        return result;
    }
}

