/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.design.IntValue;
import ec.tstoolkit.timeseries.TsException;

public enum TsFrequency implements IntValue
{
    Undefined(0),
    Yearly(1),
    HalfYearly(2),
    QuadriMonthly(3),
    Quarterly(4),
    BiMonthly(6),
    Monthly(12);

    private final int value;
    static final TsFrequency[] allFreqs;

    public static TsFrequency valueOf(int value) {
        return IntValue.valueOf(TsFrequency.class, value).orElse(null);
    }

    private TsFrequency(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public boolean contains(TsFrequency hfreq) {
        return hfreq.value > this.value && hfreq.value % this.value == 0;
    }

    public int ratio(TsFrequency lfreq) {
        if (this.value % lfreq.value != 0) {
            throw new TsException("Incompatible frequencies");
        }
        return this.value / lfreq.value;
    }

    static {
        allFreqs = new TsFrequency[]{Yearly, HalfYearly, QuadriMonthly, Quarterly, BiMonthly, Monthly};
    }
}

