/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfModel;

public class SsfFunctionInstance<S extends ISsf>
implements ISsqFunctionInstance,
IFunctionInstance {
    public final SsfFunction<S> fn;
    public final S ssf;
    private DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> m_ll;

    public SsfFunctionInstance(SsfFunction<S> fn, IReadDataBlock p) {
        this.fn = fn;
        if (p != null) {
            this.ssf = (ISsf)fn.mapper.map(p);
            SsfModel<S> m = new SsfModel<S>(this.ssf, fn.model);
            this.m_ll = fn.algorithm.evaluate(m);
        } else {
            this.ssf = fn.model.ssf;
            this.m_ll = fn.algorithm.evaluate(fn.model);
        }
    }

    @Override
    public double[] getE() {
        return this.m_ll.getE();
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.m_ll == null ? null : this.m_ll.getLikelihood();
    }

    @Override
    public IReadDataBlock getParameters() {
        return this.fn.mapper.map(this.ssf);
    }

    @Override
    public double getSsqE() {
        return this.m_ll != null ? this.m_ll.getSsqValue() : Double.NaN;
    }

    @Override
    public double getValue() {
        return this.m_ll == null ? Double.NaN : this.m_ll.getValue();
    }
}

