/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.ILinearSystemSolver;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public abstract class AbstractLinearSystemSolver
implements ILinearSystemSolver {
    private double m_eps = Math.pow(2.0, -52.0);

    public abstract void decompose(SubMatrix var1);

    public double getEpsilon() {
        return this.m_eps;
    }

    public Matrix inverse() throws MatrixException {
        return this.solve(Matrix.identity(this.getEquationsCount()));
    }

    public void setEpsilon(double value) {
        this.m_eps = value;
    }

    public double[] solve(double[] in) {
        DataBlock rslt = new DataBlock(in.length);
        this.solve(new DataBlock(in), rslt);
        return rslt.getData();
    }

    public abstract void solve(DataBlock var1, DataBlock var2) throws MatrixException;

    @Override
    public Matrix solve(Matrix m) throws MatrixException {
        if (m == null) {
            return null;
        }
        int n = this.getEquationsCount();
        if (!this.isFullRank()) {
            throw new MatrixException("m_err_rank");
        }
        int nc = m.getColumnsCount();
        Matrix S = new Matrix(n, nc);
        DataBlockIterator xin = m.columns();
        DataBlockIterator xout = S.columns();
        DataBlock icur = xin.getData();
        DataBlock ocur = xout.getData();
        do {
            this.solve(icur, ocur);
        } while (xin.next() && xout.next());
        return S;
    }
}

