/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import java.util.ArrayList;
import java.util.List;

public class SplineInterpolation {
    private final List<Point> points_ = new ArrayList<Point>();
    private Spline[] splines_;

    public boolean add(double x, double y) {
        if (!this.points_.isEmpty() && this.points_.get((int)(this.points_.size() - 1)).x >= x) {
            return false;
        }
        this.points_.add(new Point(x, y));
        return true;
    }

    public double evaluate(double x) {
        if (!this.calc()) {
            return Double.NaN;
        }
        if (x < this.splines_[0].x0) {
            return this.lextrapolate(x);
        }
        for (int i = 0; i < this.splines_.length; ++i) {
            if (!(x <= this.splines_[i].x0 + this.splines_[i].h)) continue;
            return this.splines_[i].evaluate(x);
        }
        return this.uextrapolate(x);
    }

    private double lextrapolate(double x) {
        Spline cur = this.splines_[0];
        return cur.a + cur.b * (x - cur.x0);
    }

    private double uextrapolate(double x) {
        Ols ols = new Ols();
        int n = (int)this.points_.get((int)(this.points_.size() - 1)).x + 1;
        double[] y = new double[n];
        double[] t = new double[n];
        for (int i = 0; i < y.length; ++i) {
            t[i] = i;
            y[i] = this.evaluate(i);
        }
        RegModel model = new RegModel();
        model.setY(new DataBlock(y));
        model.addX(new DataBlock(t));
        model.setMeanCorrection(true);
        ols.process(model);
        double[] b = ols.getLikelihood().getB();
        int last = this.points_.size() - 1;
        Spline cur = this.splines_[last - 1];
        Point p = this.points_.get(last);
        double dx = x - p.x;
        return p.y + dx * (cur.b + cur.h * cur.c);
    }

    private boolean calc() {
        double h;
        Point x0;
        if (this.splines_ != null) {
            return true;
        }
        int n = this.points_.size();
        if (n < 2) {
            return false;
        }
        int m = n - 1;
        this.splines_ = new Spline[m];
        double[] q = new double[m];
        Point xm1 = x0 = this.points_.get(0);
        double hprev = 0.0;
        for (int i = 0; i < m; ++i) {
            Point x1 = this.points_.get(i + 1);
            h = x1.x - x0.x;
            Spline spline = new Spline(x0.x, h);
            spline.a = x0.y;
            this.splines_[i] = spline;
            if (i > 0) {
                q[i] = 3.0 * ((x1.y - x0.y) / h - (x0.y - xm1.y) / hprev);
                xm1 = x0;
            }
            x0 = x1;
            hprev = h;
        }
        double[] z = new double[n];
        double[] w = new double[m];
        for (int i = 1; i < m; ++i) {
            h = this.splines_[i].h;
            hprev = this.splines_[i - 1].h;
            double l = 2.0 * (h + hprev) - this.splines_[i - 1].h * w[i - 1];
            w[i] = h / l;
            z[i] = (q[i] - h * z[i - 1]) / l;
        }
        double c = 0.0;
        double a = this.points_.get((int)m).y;
        for (int i = m - 1; i >= 0; --i) {
            Spline cur = this.splines_[i];
            cur.c = z[i] - w[i] * c;
            cur.b = (a - cur.a) / cur.h - cur.h * (c + 2.0 * cur.c) / 3.0;
            cur.d = (c - cur.c) / (3.0 * cur.h);
            a = cur.a;
            c = cur.c;
        }
        return true;
    }

    private static class Spline {
        final double x0;
        final double h;
        double a;
        double b;
        double c;
        double d;

        Spline(double x0, double h) {
            this.x0 = x0;
            this.h = h;
        }

        double span() {
            return this.h;
        }

        double evaluate(double x) {
            double z = x - this.x0;
            double p = this.d * z + this.c;
            p = p * z + this.b;
            p = p * z + this.a;
            return p;
        }
    }

    private static class Point {
        final double x;
        final double y;

        Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

