/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionView;

public class DefaultRFunctionView
extends RFunctionView {
    protected JScrollPane scroller;
    protected JPanel paramPanel;
    protected RFunction model;
    protected VariableSelectorWidget selector;
    protected Vector widgets = new Vector();
    protected boolean outsideSelector = false;

    public DefaultRFunctionView() {
        this.initGui();
    }

    public DefaultRFunctionView(Param param) {
        this.initGui();
        this.setModel(param);
    }

    public DefaultRFunctionView(Param param, VariableSelectorWidget variableSelectorWidget) {
        this.selector = variableSelectorWidget;
        this.outsideSelector = true;
        this.initGui();
        this.setModel(param);
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.scroller = new JScrollPane();
        this.scroller.setHorizontalScrollBarPolicy(31);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.scroller.setBorder(border);
        this.add(this.scroller);
        this.paramPanel = new JPanel();
        this.scroller.setViewportView(this.paramPanel);
        this.setMaximumSize(new Dimension(365, 365));
        this.setPreferredSize(new Dimension(365, 365));
    }

    public void updateGui() {
        boolean bl = false;
        for (int i = 0; i < this.model.getParams().size(); ++i) {
            Param param = (Param)this.model.getParams().get(i);
            if (!param.requiresVariableSelector()) continue;
            bl = true;
            break;
        }
        boolean bl2 = bl = bl && !this.outsideSelector;
        if (bl) {
            if (this.selector == null) {
                this.selector = new VariableSelectorWidget();
                this.selector.setPreferredSize(new Dimension(150, 300));
            }
            this.removeAll();
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.add((Component)this.scroller, new AnchorConstraint(60, 1000, 1000, 160, 2, 1, 1, 2));
            this.add((Component)this.selector, new AnchorConstraint(20, 90, 1000, 10, 2, 0, 1, 2));
        } else {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(this.scroller);
        }
        this.paramPanel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.paramPanel, 1);
        this.paramPanel.setLayout(boxLayout);
        int n = 30;
        int n2 = 30;
        for (int i = 0; i < this.model.getParams().size(); ++i) {
            Param param = (Param)this.model.getParams().get(i);
            ParamWidget paramWidget = !param.requiresVariableSelector() ? param.getView() : param.getView(this.selector);
            paramWidget.setAlignmentX(0.5f);
            paramWidget.setMaximumSize(new Dimension(365, paramWidget.getMaximumSize().height));
            n += paramWidget.getMaximumSize().height;
            n2 += paramWidget.getPreferredSize().height;
            this.widgets.add(paramWidget);
            this.paramPanel.add(paramWidget);
            this.paramPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        this.setMaximumSize(new Dimension(365, n));
        this.setPreferredSize(new Dimension(365, n2));
        this.paramPanel.validate();
        this.paramPanel.repaint();
    }

    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    public void setModel(RFunction rFunction) {
        this.model = rFunction;
        this.updateGui();
    }

    public void updateModel() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            ((ParamWidget)e).updateModel();
        }
    }

    public void setModel(Param param) {
        this.setModel((RFunction)param);
    }
}

