/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.widgets.DeducerWidget;

public class ListWidget
extends JPanel
implements DeducerWidget {
    protected DJList list;
    protected DefaultListModel listModel;
    protected DefaultListModel lastModel;
    protected DefaultListModel initialModel;
    protected JScrollPane scroller;
    protected String title;

    public ListWidget() {
        this.initGUI();
    }

    public ListWidget(String string) {
        this.title = string;
        this.initGUI();
    }

    public ListWidget(String string, String[] stringArray) {
        this.title = string;
        this.initGUI();
        this.setDefaultModel(stringArray);
    }

    public ListWidget(String[] stringArray) {
        this.initGUI();
        this.setDefaultModel(stringArray);
    }

    public void initGUI() {
        this.scroller = new JScrollPane();
        this.list = new DJList();
        this.listModel = new DefaultListModel();
        this.initialModel = new DefaultListModel();
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add(this.scroller);
        this.scroller.setViewportView(this.list);
        this.list.setModel(this.listModel);
        if (this.title != null) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void addItems(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.addElement(objectArray[i]);
        }
    }

    public void addItem(Object object) {
        this.listModel.addElement(object);
    }

    public void addItem(Object object, int n) {
        this.listModel.add(n, object);
    }

    public void addItem(String string, int n) {
        this.listModel.add(n, string);
    }

    public void addItems(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.listModel.addElement(stringArray[i]);
        }
    }

    public void addItem(String string) {
        this.listModel.addElement(string);
    }

    public void setDefaultModel(Object[] objectArray) {
        this.initialModel = new DefaultListModel();
        for (int i = 0; i < objectArray.length; ++i) {
            this.initialModel.addElement(objectArray[i]);
        }
    }

    public void setDefaultModel(String[] stringArray) {
        this.initialModel = new DefaultListModel();
        for (int i = 0; i < stringArray.length; ++i) {
            this.initialModel.addElement(stringArray[i]);
        }
    }

    public boolean removeItems(Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl2 = this.listModel.removeElement(objectArray[i]);
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public boolean removeItems(String[] stringArray) {
        return this.removeItems(stringArray);
    }

    public boolean removeItem(Object object) {
        return this.listModel.removeElement(object);
    }

    public boolean removeItem(String string) {
        return this.listModel.removeElement(string);
    }

    public Object removeItem(int n) {
        return this.listModel.remove(n);
    }

    public void removeAllItems() {
        this.listModel.removeAllElements();
    }

    public DJList getList() {
        return this.list;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public Object[] getSelectedItems() {
        return this.list.getSelectedValues();
    }

    public String[] getItems() {
        String[] stringArray = new String[this.list.getModel().getSize()];
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            stringArray[i] = (String)this.list.getModel().getElementAt(i);
        }
        return stringArray;
    }

    public void addListener(EventListener eventListener) {
        if (eventListener instanceof ListSelectionListener) {
            this.list.addListSelectionListener((ListSelectionListener)eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.list.addMouseListener((MouseListener)eventListener);
        }
        if (eventListener instanceof KeyListener) {
            this.list.addKeyListener((KeyListener)eventListener);
        }
    }

    public Object getModel() {
        return this.listModel;
    }

    public String getRModel() {
        return Deducer.makeRCollection(this.listModel, "c", true);
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.initialModel.size(); ++i) {
            defaultListModel.addElement(this.initialModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void resetToLast() {
        if (this.lastModel == null) {
            this.reset();
            return;
        }
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.lastModel.size(); ++i) {
            defaultListModel.addElement(this.lastModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void setDefaultModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.initialModel = defaultListModel;
    }

    public void setLastModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.lastModel = defaultListModel;
    }

    public void setModel(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)object;
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        this.listModel = defaultListModel;
        this.list.setModel(this.listModel);
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

