/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractBuilder;
import com.jgoodies.forms.factories.ComponentFactory2;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractButtonPanelBuilder
extends AbstractBuilder {
    protected static final String NARROW_KEY = "jgoodies.isNarrow";
    private boolean leftToRight;

    protected AbstractButtonPanelBuilder(FormLayout layout, JPanel container) {
        super(layout, container);
        this.setOpaque(false);
        ComponentOrientation orientation = container.getComponentOrientation();
        this.leftToRight = orientation.isLeftToRight() || !orientation.isHorizontal();
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    public final void setBackground(Color background) {
        this.getPanel().setBackground(background);
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setOpaque(boolean b) {
        this.getPanel().setOpaque(b);
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final void setLeftToRight(boolean b) {
        this.leftToRight = b;
    }

    protected final void nextColumn() {
        this.nextColumn(1);
    }

    private void nextColumn(int columns) {
        this.currentCellConstraints.gridX += columns * this.getColumnIncrementSign();
    }

    protected int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    protected final void nextRow() {
        this.nextRow(1);
    }

    private void nextRow(int rows) {
        this.currentCellConstraints.gridY += rows;
    }

    protected final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    protected final void appendGlueColumn() {
        this.appendColumn(FormFactory.GLUE_COLSPEC);
    }

    protected final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
    }

    protected final void appendUnrelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.UNRELATED_GAP_COLSPEC);
    }

    protected final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    protected final void appendGlueRow() {
        this.appendRow(FormFactory.GLUE_ROWSPEC);
    }

    protected final void appendRelatedComponentsGapRow() {
        this.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
    }

    protected final void appendUnrelatedComponentsGapRow() {
        this.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    protected final Component add(Component component) {
        this.getContainer().add(component, this.currentCellConstraints);
        return component;
    }

    protected JButton createButton(Action action) {
        if (this.getComponentFactory() instanceof ComponentFactory2) {
            return ((ComponentFactory2)this.getComponentFactory()).createButton(action);
        }
        return new JButton(action);
    }

    private int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }
}

