/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class UniformIntegerOperator
extends SimpleMCMCOperator {
    private final int howMany;
    private Variable parameter = null;
    private int upper;
    private int lower;

    public UniformIntegerOperator(Parameter parameter, int n, int n2, double d, int n3) {
        this(parameter, d, n3);
        this.lower = n;
        this.upper = n2;
    }

    public UniformIntegerOperator(Parameter parameter, int n, int n2, double d) {
        this(parameter, n, n2, d, 1);
    }

    public UniformIntegerOperator(Variable variable, double d, int n) {
        this.parameter = variable;
        this.howMany = n;
        this.setWeight(d);
    }

    public Parameter getParameter() {
        return (Parameter)this.parameter;
    }

    public Variable getVariable() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        for (int i = 0; i < this.howMany; ++i) {
            int n;
            int n2 = MathUtils.nextInt(this.parameter.getSize());
            if (this.parameter instanceof Parameter) {
                n = MathUtils.nextInt(this.upper - this.lower + 1) + this.lower;
                ((Parameter)this.parameter).setParameterValue(n2, n);
                continue;
            }
            n = (Integer)this.parameter.getBounds().getUpperLimit(n2);
            int n3 = (Integer)this.parameter.getBounds().getLowerLimit(n2);
            int n4 = MathUtils.nextInt(n - n3 + 1) + n3;
            this.parameter.setValue(n2, n4);
        }
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "uniformInteger(" + this.parameter.getId() + ")";
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public String toString() {
        return "uniformIntegerOperator(" + this.parameter.getId() + ")";
    }
}

