/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.util.Units;
import java.util.Arrays;

public class Intervals
implements IntervalList {
    private Units.Type units = Units.Type.GENERATIONS;
    private double startTime = Double.POSITIVE_INFINITY;
    private Event[] events;
    private int eventCount;
    private int sampleCount;
    private boolean intervalsKnown = false;
    private double[] intervals;
    private int[] lineageCounts;
    private IntervalType[] intervalTypes;
    private int intervalCount = 0;

    public Intervals(int n) {
        this.events = new Event[n];
        for (int i = 0; i < n; ++i) {
            this.events[i] = new Event();
        }
        this.eventCount = 0;
        this.sampleCount = 0;
        this.intervals = new double[n - 1];
        this.intervalTypes = new IntervalType[n - 1];
        this.lineageCounts = new int[n - 1];
        this.intervalsKnown = false;
    }

    public void copyIntervals(Intervals intervals) {
        this.intervalsKnown = intervals.intervalsKnown;
        this.eventCount = intervals.eventCount;
        this.sampleCount = intervals.sampleCount;
        this.intervalCount = intervals.intervalCount;
        this.startTime = intervals.startTime;
        if (this.intervalsKnown) {
            System.arraycopy(intervals.intervals, 0, this.intervals, 0, this.intervals.length);
            System.arraycopy(intervals.intervalTypes, 0, this.intervalTypes, 0, this.intervals.length);
            System.arraycopy(intervals.lineageCounts, 0, this.lineageCounts, 0, this.intervals.length);
        }
    }

    public void resetEvents() {
        this.startTime = Double.POSITIVE_INFINITY;
        this.intervalsKnown = false;
        this.eventCount = 0;
        this.sampleCount = 0;
    }

    public void addSampleEvent(double d) {
        if (d < this.startTime) {
            this.startTime = d;
        }
        this.events[this.eventCount].time = d;
        this.events[this.eventCount].type = IntervalType.SAMPLE;
        ++this.eventCount;
        ++this.sampleCount;
        this.intervalsKnown = false;
    }

    public void addCoalescentEvent(double d) {
        this.events[this.eventCount].time = d;
        this.events[this.eventCount].type = IntervalType.COALESCENT;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    public void addMigrationEvent(double d, int n) {
        this.events[this.eventCount].time = d;
        this.events[this.eventCount].type = IntervalType.MIGRATION;
        this.events[this.eventCount].info = n;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    public void addNothingEvent(double d) {
        this.events[this.eventCount].time = d;
        this.events[this.eventCount].type = IntervalType.NOTHING;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    @Override
    public double getInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervals[n];
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events[n].time;
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.lineageCounts[n];
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n < this.intervalCount - 1) {
            return this.lineageCounts[n] - this.lineageCounts[n + 1];
        }
        return this.lineageCounts[n] - 1;
    }

    @Override
    public double getStartTime() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.startTime;
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalTypes[n];
    }

    @Override
    public double getTotalDuration() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events[this.eventCount - 1].time;
    }

    @Override
    public boolean isBinaryCoalescent() {
        return true;
    }

    @Override
    public boolean isCoalescentOnly() {
        return true;
    }

    @Override
    public void calculateIntervals() {
        if (this.eventCount < 2) {
            throw new IllegalArgumentException("Too few events to construct intervals");
        }
        Arrays.sort(this.events, 0, this.eventCount);
        if (this.events[0].type != IntervalType.SAMPLE) {
            throw new IllegalArgumentException("First event is not a sample event");
        }
        this.intervalCount = this.eventCount - 1;
        double d = this.events[0].time;
        int n = 1;
        for (int i = 1; i < this.eventCount; ++i) {
            this.intervals[i - 1] = this.events[i].time - d;
            this.intervalTypes[i - 1] = this.events[i].type;
            this.lineageCounts[i - 1] = n++;
            if (this.events[i].type != IntervalType.SAMPLE && this.events[i].type == IntervalType.COALESCENT) {
                --n;
            }
            d = this.events[i].time;
        }
        this.intervalsKnown = true;
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    private class Event
    implements Comparable {
        IntervalType type;
        double time;
        int info;

        private Event() {
        }

        public int compareTo(Object object) {
            double d = ((Event)object).time;
            if (d < this.time) {
                return 1;
            }
            if (d > this.time) {
                return -1;
            }
            return this.type.compareTo(((Event)object).type);
        }
    }
}

